/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.widget.TextAlignment;
import com.facebook.litho.widget.TextSpec;
import com.facebook.litho.widget.VerticalGravity;
import com.facebook.rendercore.utils.SynchronizedTypefaceHelper;

public final class TextStylesHelper {
    private static final TextUtils.TruncateAt[] TRUNCATE_AT;
    public static final int DEFAULT_EMS = -1;
    public static final int DEFAULT_MIN_WIDTH = 0;
    public static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    public static final int DEFAULT_BREAK_STRATEGY = 0;
    public static final int DEFAULT_HYPHENATION_FREQUENCY = 0;
    public static final int DEFAULT_JUSTIFICATION_MODE = 0;
    public static final TextAlignment textAlignmentDefault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLoadStyle(ComponentContext c, Output<TextUtils.TruncateAt> ellipsize, Output<Float> extraSpacing, Output<Boolean> shouldIncludeFontPadding, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Integer> minEms, Output<Integer> maxEms, Output<Integer> minTextWidth, Output<Integer> maxTextWidth, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<TextAlignment> textAlignment, Output<Integer> breakStrategy, Output<Integer> hyphenationFrequency, Output<Integer> justificationMode, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<VerticalGravity> verticalGravity, Output<Typeface> typeface) {
        Resources.Theme theme;
        TypedArray a;
        Resources.Theme theme2 = c.getAndroidContext().getTheme();
        if (ComponentsConfiguration.NEEDS_THEME_SYNCHRONIZATION) {
            Resources.Theme theme3 = theme2;
            synchronized (theme3) {
                a = c.obtainStyledAttributes(R.styleable.Text_TextAppearanceAttr, 0);
            }
        } else {
            a = c.obtainStyledAttributes(R.styleable.Text_TextAppearanceAttr, 0);
        }
        int textAppearanceResId = a.getResourceId(R.styleable.Text_TextAppearanceAttr_android_textAppearance, -1);
        a.recycle();
        if (textAppearanceResId != -1) {
            if (ComponentsConfiguration.NEEDS_THEME_SYNCHRONIZATION) {
                theme = theme2;
                synchronized (theme) {
                    a = theme2.obtainStyledAttributes(textAppearanceResId, R.styleable.Text);
                }
            } else {
                a = theme2.obtainStyledAttributes(textAppearanceResId, R.styleable.Text);
            }
            TextStylesHelper.resolveStyleAttrsForTypedArray(a, ellipsize, extraSpacing, shouldIncludeFontPadding, spacingMultiplier, minLines, maxLines, minEms, maxEms, minTextWidth, maxTextWidth, isSingleLine, text, textColorStateList, linkColor, highlightColor, textSize, textAlignment, breakStrategy, hyphenationFrequency, justificationMode, textStyle, shadowRadius, shadowDx, shadowDy, shadowColor, verticalGravity, typeface);
            a.recycle();
        }
        if (ComponentsConfiguration.NEEDS_THEME_SYNCHRONIZATION) {
            theme = theme2;
            synchronized (theme) {
                a = c.obtainStyledAttributes(R.styleable.Text, 0);
            }
        } else {
            a = c.obtainStyledAttributes(R.styleable.Text, 0);
        }
        TextStylesHelper.resolveStyleAttrsForTypedArray(a, ellipsize, extraSpacing, shouldIncludeFontPadding, spacingMultiplier, minLines, maxLines, minEms, maxEms, minTextWidth, maxTextWidth, isSingleLine, text, textColorStateList, linkColor, highlightColor, textSize, textAlignment, breakStrategy, hyphenationFrequency, justificationMode, textStyle, shadowRadius, shadowDx, shadowDy, shadowColor, verticalGravity, typeface);
        a.recycle();
    }

    private static void resolveStyleAttrsForTypedArray(TypedArray a, Output<TextUtils.TruncateAt> ellipsize, Output<Float> extraSpacing, Output<Boolean> shouldIncludeFontPadding, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Integer> minEms, Output<Integer> maxEms, Output<Integer> minTextWidth, Output<Integer> maxTextWidth, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<TextAlignment> textAlignment, Output<Integer> breakStrategy, Output<Integer> hyphenationFrequency, Output<Integer> justificationMode, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<VerticalGravity> verticalGravity, Output<Typeface> typeface) {
        int viewTextAlignment = 1;
        int gravity = 0;
        String fontFamily = null;
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Text_android_text) {
                text.set((Object)a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColor) {
                textColorStateList.set((Object)a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textSize) {
                textSize.set((Object)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_ellipsize) {
                int index = a.getInteger(attr2, 0);
                if (index <= 0) continue;
                ellipsize.set((Object)TRUNCATE_AT[index - 1]);
                continue;
            }
            if (attr2 == R.styleable.Text_android_textAlignment) {
                if (Build.VERSION.SDK_INT < 17) continue;
                viewTextAlignment = a.getInt(attr2, -1);
                textAlignment.set((Object)TextStylesHelper.getTextAlignment(viewTextAlignment, gravity));
                continue;
            }
            if (attr2 == R.styleable.Text_android_gravity) {
                gravity = a.getInt(attr2, -1);
                textAlignment.set((Object)TextStylesHelper.getTextAlignment(viewTextAlignment, gravity));
                verticalGravity.set((Object)TextStylesHelper.getVerticalGravity(gravity));
                continue;
            }
            if (attr2 == R.styleable.Text_android_includeFontPadding) {
                shouldIncludeFontPadding.set((Object)a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minLines) {
                minLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxLines) {
                maxLines.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_singleLine) {
                isSingleLine.set((Object)a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorLink) {
                linkColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textColorHighlight) {
                highlightColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_textStyle) {
                textStyle.set((Object)a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_lineSpacingExtra) {
                extraSpacing.set((Object)Float.valueOf(a.getDimensionPixelOffset(attr2, 0)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_lineSpacingMultiplier) {
                spacingMultiplier.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDx) {
                shadowDx.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowDy) {
                shadowDy.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowRadius) {
                shadowRadius.set((Object)Float.valueOf(a.getFloat(attr2, 0.0f)));
                continue;
            }
            if (attr2 == R.styleable.Text_android_shadowColor) {
                shadowColor.set((Object)a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minEms) {
                minEms.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxEms) {
                maxEms.set((Object)a.getInteger(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.Text_android_minWidth) {
                minTextWidth.set((Object)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_maxWidth) {
                maxTextWidth.set((Object)a.getDimensionPixelSize(attr2, Integer.MAX_VALUE));
                continue;
            }
            if (attr2 == R.styleable.Text_android_fontFamily) {
                fontFamily = a.getString(attr2);
                continue;
            }
            if (attr2 == R.styleable.Text_android_breakStrategy) {
                if (Build.VERSION.SDK_INT < 23) continue;
                breakStrategy.set((Object)a.getInt(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.Text_android_hyphenationFrequency) {
                if (Build.VERSION.SDK_INT < 23) continue;
                hyphenationFrequency.set((Object)a.getInt(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.Text_android_justificationMode || Build.VERSION.SDK_INT < 26) continue;
            justificationMode.set((Object)a.getInt(attr2, 0));
        }
        if (fontFamily != null) {
            Integer styleValue = (Integer)textStyle.get();
            typeface.set((Object)Typeface.create(fontFamily, (int)(styleValue == null ? -1 : styleValue)));
        }
    }

    private static TextAlignment getTextAlignment(int viewTextAlignment, int gravity) {
        TextAlignment alignment;
        switch (viewTextAlignment) {
            case 2: {
                alignment = TextAlignment.TEXT_START;
                break;
            }
            case 3: {
                alignment = TextAlignment.TEXT_END;
                break;
            }
            case 4: {
                alignment = TextAlignment.CENTER;
                break;
            }
            case 5: {
                alignment = TextAlignment.LAYOUT_START;
                break;
            }
            case 6: {
                alignment = TextAlignment.LAYOUT_END;
                break;
            }
            case 0: 
            case 1: {
                alignment = TextStylesHelper.getTextAlignment(gravity);
                break;
            }
            default: {
                alignment = textAlignmentDefault;
            }
        }
        return alignment;
    }

    private static TextAlignment getTextAlignment(int gravity) {
        TextAlignment alignment;
        switch (gravity & 0x800007) {
            case 0x800003: {
                alignment = TextAlignment.LAYOUT_START;
                break;
            }
            case 0x800005: {
                alignment = TextAlignment.LAYOUT_END;
                break;
            }
            case 3: {
                alignment = TextAlignment.LEFT;
                break;
            }
            case 5: {
                alignment = TextAlignment.RIGHT;
                break;
            }
            case 1: {
                alignment = TextAlignment.CENTER;
                break;
            }
            default: {
                alignment = textAlignmentDefault;
            }
        }
        return alignment;
    }

    private static VerticalGravity getVerticalGravity(int gravity) {
        VerticalGravity verticalGravity;
        switch (gravity & 0x70) {
            case 48: {
                verticalGravity = VerticalGravity.TOP;
                break;
            }
            case 16: {
                verticalGravity = VerticalGravity.CENTER;
                break;
            }
            case 80: {
                verticalGravity = VerticalGravity.BOTTOM;
                break;
            }
            default: {
                verticalGravity = TextSpec.verticalGravity;
            }
        }
        return verticalGravity;
    }

    static {
        SynchronizedTypefaceHelper.setupSynchronizedTypeface();
        TRUNCATE_AT = TextUtils.TruncateAt.values();
        textAlignmentDefault = TextAlignment.TEXT_START;
    }
}

