/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.TouchableFeedbackSpec;
import com.facebook.rendercore.primitives.utils.EquivalenceUtils;
import java.util.BitSet;

@Generated
public final class TouchableFeedback
extends SpecGeneratedComponent {
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int color = -1;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=10)
    Component content;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int highlightColor = -3355444;

    private TouchableFeedback() {
        super("TouchableFeedback");
    }

    public TouchableFeedback makeShallowCopy() {
        TouchableFeedback component = (TouchableFeedback)super.makeShallowCopy();
        component.content = component.content != null ? component.content.makeShallowCopy() : null;
        return component;
    }

    protected Component onCreateLayout(ComponentContext c) {
        Component _result = TouchableFeedbackSpec.onCreateLayout(c, this.content, this.getRippleDrawable(c));
        return _result;
    }

    public static Builder create(ComponentContext context) {
        return TouchableFeedback.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        TouchableFeedback instance = new TouchableFeedback();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    private Drawable getRippleDrawable(ComponentContext c) {
        String globalKey = c.getGlobalKey();
        RippleDrawableInputs inputs = new RippleDrawableInputs(globalKey, this.color, this.highlightColor);
        Drawable rippleDrawable = (Drawable)c.getCachedValue((Object)inputs);
        if (rippleDrawable == null) {
            rippleDrawable = TouchableFeedbackSpec.onCalculateCachedValue(c, this.color, this.highlightColor);
            c.putCachedValue((Object)inputs, (Object)rippleDrawable);
        }
        return rippleDrawable;
    }

    protected Component getSimpleNameDelegate() {
        return this.content;
    }

    @Generated
    private static class RippleDrawableInputs {
        private final String globalKey;
        private final int color;
        private final int highlightColor;

        RippleDrawableInputs(String globalKey, int color, int highlightColor) {
            this.globalKey = globalKey;
            this.color = color;
            this.highlightColor = highlightColor;
        }

        public int hashCode() {
            return CommonUtils.hash((Object[])new Object[]{this.globalKey, this.color, this.highlightColor, this.getClass()});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof RippleDrawableInputs)) {
                return false;
            }
            RippleDrawableInputs cachedValueInputs = (RippleDrawableInputs)other;
            if (!EquivalenceUtils.equals((Object)this.globalKey, (Object)cachedValueInputs.globalKey)) {
                return false;
            }
            if (this.color != cachedValueInputs.color) {
                return false;
            }
            return this.highlightColor == cachedValueInputs.highlightColor;
        }
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        TouchableFeedback mTouchableFeedback;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"content"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, TouchableFeedback touchableFeedbackRef) {
            super(context, defStyleAttr, defStyleRes, (Component)touchableFeedbackRef);
            this.mTouchableFeedback = touchableFeedbackRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mTouchableFeedback = (TouchableFeedback)component;
        }

        @PropSetter(value="color", required=false)
        public Builder color(@ColorInt int color) {
            this.mTouchableFeedback.color = color;
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorRes(@ColorRes int resId) {
            this.mTouchableFeedback.color = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTouchableFeedback.color = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="color", required=false)
        public Builder colorAttr(@AttrRes int attrResId) {
            this.mTouchableFeedback.color = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="content", required=true)
        @RequiredProp(value="content")
        public Builder content(Component content) {
            this.mTouchableFeedback.content = content == null ? null : content.makeShallowCopy();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="content", required=true)
        @RequiredProp(value="content")
        public Builder content(Component.Builder<?> contentBuilder) {
            this.mTouchableFeedback.content = contentBuilder == null ? null : contentBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColor(@ColorInt int highlightColor) {
            this.mTouchableFeedback.highlightColor = highlightColor;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorRes(@ColorRes int resId) {
            this.mTouchableFeedback.highlightColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTouchableFeedback.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mTouchableFeedback.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public TouchableFeedback build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mTouchableFeedback;
        }
    }
}

