/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Diff;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateValue;
import com.facebook.litho.Wrapper;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.ShouldUpdate;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.LithoScrollView;
import com.facebook.litho.widget.R;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.litho.widget.VerticalScrollEventsController;

@MountSpec(hasChildLithoViews=true, isPureRender=true)
public class VerticalScrollSpec {
    @PropDefault
    static final boolean scrollbarFadingEnabled = true;
    @PropDefault
    static final int overScrollMode = 1;

    @OnCreateInitialState
    static void onCreateInitialState(ComponentContext context, StateValue<LithoScrollView.ScrollPosition> scrollPosition, StateValue<ComponentTree> childComponentTree, @Prop Component childComponent, @Prop(optional=true) int initialScrollOffsetPixels, @Prop(optional=true) boolean incrementalMountEnabled) {
        LithoScrollView.ScrollPosition initialScrollPosition = new LithoScrollView.ScrollPosition();
        initialScrollPosition.y = initialScrollOffsetPixels;
        scrollPosition.set((Object)initialScrollPosition);
        childComponentTree.set((Object)ComponentTree.createNestedComponentTree((ComponentContext)context, (Component)childComponent).incrementalMount(incrementalMountEnabled).build());
    }

    @OnMeasure
    static void onMeasure(ComponentContext c, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, @Prop Component childComponent, @Prop(optional=true) boolean fillViewport, @State ComponentTree childComponentTree, Output<Integer> measuredWidth, Output<Integer> measuredHeight) {
        int horizontalPadding = layout2.getPaddingLeft() + layout2.getPaddingRight();
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)horizontalPadding, (int)-1);
        VerticalScrollSpec.measureVerticalScroll(c, childWidthSpec, heightSpec, size, childComponentTree, childComponent, fillViewport);
        measuredWidth.set((Object)(size.width + horizontalPadding));
        measuredHeight.set((Object)size.height);
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext c, ComponentLayout layout2, @Prop Component childComponent, @Prop(optional=true) boolean fillViewport, @State ComponentTree childComponentTree, @FromMeasure Integer measuredWidth, @FromMeasure Integer measuredHeight) {
        int layoutWidth = layout2.getWidth() - layout2.getPaddingLeft() - layout2.getPaddingRight();
        int layoutHeight = layout2.getHeight() - layout2.getPaddingTop() - layout2.getPaddingBottom();
        if (measuredWidth != null && measuredWidth == layoutWidth && (!fillViewport || measuredHeight != null && measuredHeight == layoutHeight)) {
            return;
        }
        VerticalScrollSpec.measureVerticalScroll(c, SizeSpec.makeSizeSpec((int)layoutWidth, (int)0x40000000), SizeSpec.makeSizeSpec((int)layoutHeight, (int)0x40000000), null, childComponentTree, childComponent, fillViewport);
    }

    private static void measureVerticalScroll(ComponentContext c, int widthSpec, int heightSpec, @Nullable Size size, ComponentTree childComponentTree, Component childComponent, boolean fillViewport) {
        if (fillViewport) {
            childComponent = ((Wrapper.Builder)Wrapper.create((ComponentContext)c).delegate(childComponent).minHeightPx(SizeSpec.getSize((int)heightSpec))).build();
        }
        childComponentTree.setRootAndSizeSpecSync(childComponent, widthSpec, SizeSpec.makeSizeSpec((int)0, (int)0), size);
        if (size != null) {
            switch (SizeSpec.getMode((int)heightSpec)) {
                case 0x40000000: {
                    size.height = SizeSpec.getSize((int)heightSpec);
                    break;
                }
                case -2147483648: {
                    size.height = Math.max(0, Math.min(SizeSpec.getSize((int)heightSpec), size.height));
                }
            }
            size.width = Math.max(0, size.width);
            size.height = Math.max(0, size.height);
        }
    }

    @OnCreateMountContent
    public static LithoScrollView onCreateMountContent(Context context) {
        return (LithoScrollView)LayoutInflater.from((Context)context).inflate(R.layout.litho_scroll_view, null, false);
    }

    @OnMount
    static void onMount(ComponentContext context, LithoScrollView lithoScrollView, @Prop(optional=true) boolean scrollbarEnabled, @Prop(optional=true) boolean scrollbarFadingEnabled, @Prop(optional=true) boolean nestedScrollingEnabled, @Prop(optional=true) boolean incrementalMountEnabled, @Prop(optional=true) boolean verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int fadingEdgeLength, @Prop(optional=true) @Nullable VerticalScrollEventsController eventsController, @Prop(optional=true) @Nullable NestedScrollView.OnScrollChangeListener onScrollChangeListener, @Prop(optional=true) ScrollStateListener scrollStateListener, @Prop(optional=true) int overScrollMode, @Prop(optional=true) @Nullable LithoScrollView.OnInterceptTouchListener onInterceptTouchListener, @State ComponentTree childComponentTree, @State LithoScrollView.ScrollPosition scrollPosition) {
        lithoScrollView.mount(childComponentTree, scrollPosition, scrollStateListener);
        lithoScrollView.setScrollbarFadingEnabled(scrollbarFadingEnabled);
        lithoScrollView.setNestedScrollingEnabled(nestedScrollingEnabled);
        lithoScrollView.setVerticalFadingEdgeEnabled(verticalFadingEdgeEnabled);
        lithoScrollView.setFadingEdgeLength(fadingEdgeLength);
        if (Build.VERSION.SDK_INT < 21) {
            lithoScrollView.setVerticalScrollBarEnabled(false);
        } else {
            lithoScrollView.setVerticalScrollBarEnabled(scrollbarEnabled);
        }
        lithoScrollView.setOnScrollChangeListener(onScrollChangeListener);
        lithoScrollView.setOnInterceptTouchListener(onInterceptTouchListener);
        lithoScrollView.setOverScrollMode(overScrollMode);
        if (eventsController != null) {
            eventsController.setScrollView(lithoScrollView);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, LithoScrollView lithoScrollView, @Prop(optional=true) @Nullable VerticalScrollEventsController eventsController) {
        if (eventsController != null) {
            eventsController.setScrollView(null);
        }
        lithoScrollView.setOnScrollChangeListener(null);
        lithoScrollView.setOnInterceptTouchListener(null);
        lithoScrollView.unmount();
    }

    @ShouldUpdate(onMount=true)
    static boolean shouldUpdate(@Prop Diff<Component> childComponent, @Prop(optional=true) Diff<Boolean> scrollbarEnabled, @Prop(optional=true) Diff<Boolean> scrollbarFadingEnabled, @Prop(optional=true) Diff<Boolean> fillViewport, @Prop(optional=true) Diff<Boolean> nestedScrollingEnabled, @Prop(optional=true) Diff<Boolean> incrementalMountEnabled) {
        return !((Component)childComponent.getPrevious()).isEquivalentTo((Component)childComponent.getNext()) || !((Boolean)scrollbarEnabled.getPrevious()).equals(scrollbarEnabled.getNext()) || !((Boolean)scrollbarFadingEnabled.getPrevious()).equals(scrollbarFadingEnabled.getNext()) || !((Boolean)fillViewport.getPrevious()).equals(fillViewport.getNext()) || !((Boolean)nestedScrollingEnabled.getPrevious()).equals(nestedScrollingEnabled.getNext()) || !((Boolean)incrementalMountEnabled.getPrevious()).equals(incrementalMountEnabled.getNext());
    }
}

