/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGClientListener;
import com.facebook.nailgun.NGCommunicator;
import com.facebook.nailgun.NGHeartbeatListener;
import com.facebook.nailgun.NGServer;
import com.facebook.nailgun.ThreadLocalInputStream;
import com.facebook.nailgun.ThreadLocalPrintStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Properties;

public class NGContext {
    private Properties remoteEnvironment = null;
    private InetAddress remoteHost = null;
    private int remotePort = 0;
    private String[] args = null;
    private NGServer server = null;
    private String command = null;
    private String workingDirectory = null;
    public InputStream in = null;
    public PrintStream out = null;
    public PrintStream err = null;
    private NGCommunicator communicator = null;

    public void setCommunicator(NGCommunicator comm) {
        this.communicator = comm;
    }

    public NGCommunicator getCommunicator() {
        return this.communicator;
    }

    public void setPort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setIn(InputStream in) {
        this.in = in;
        if (!(System.in instanceof ThreadLocalInputStream)) {
            throw new IllegalStateException("System.in should be set by nailgun.");
        }
        ThreadLocalInputStream tls = (ThreadLocalInputStream)System.in;
        tls.init(in);
    }

    public void setOut(PrintStream out) {
        this.out = out;
        if (!(System.out instanceof ThreadLocalPrintStream)) {
            throw new IllegalStateException("System.out should be set by nailgun.");
        }
        ThreadLocalPrintStream tls = (ThreadLocalPrintStream)System.out;
        tls.init(out);
    }

    public void setErr(PrintStream err) {
        this.err = err;
        if (!(System.err instanceof ThreadLocalPrintStream)) {
            throw new IllegalStateException("System.err should be set by nailgun.");
        }
        ThreadLocalPrintStream tls = (ThreadLocalPrintStream)System.err;
        tls.init(err);
    }

    void setEnv(Properties remoteEnvironment) {
        this.remoteEnvironment = remoteEnvironment;
    }

    void setInetAddress(InetAddress remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    void setNGServer(NGServer server) {
        this.server = server;
    }

    public Properties getEnv() {
        return this.remoteEnvironment;
    }

    public String getFileSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_FILESEPARATOR");
    }

    public String getPathSeparator() {
        return this.remoteEnvironment.getProperty("NAILGUN_PATHSEPARATOR");
    }

    public InetAddress getInetAddress() {
        return this.remoteHost;
    }

    public String[] getArgs() {
        return this.args;
    }

    public NGServer getNGServer() {
        return this.server;
    }

    public void exit(int exitCode) {
        this.communicator.exit(exitCode);
    }

    public int getPort() {
        return this.remotePort;
    }

    public void assertLoopbackClient() {
        if (!this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not at loopback address.");
        }
    }

    public void assertLocalClient() {
        NetworkInterface iface = null;
        try {
            iface = NetworkInterface.getByInetAddress(this.getInetAddress());
        }
        catch (SocketException se) {
            throw new SecurityException("Unable to determine if client is local.  Assuming he isn't.");
        }
        if (iface == null && !this.getInetAddress().isLoopbackAddress()) {
            throw new SecurityException("Client is not local.");
        }
    }

    public boolean isClientConnected() {
        return this.communicator.isClientConnected();
    }

    public void addClientListener(NGClientListener listener) {
        this.communicator.addClientListener(listener);
    }

    public void removeClientListener(NGClientListener listener) {
        this.communicator.removeClientListener(listener);
    }

    public void removeAllClientListeners() {
        this.communicator.removeAllClientListeners();
    }

    public void addHeartbeatListener(NGHeartbeatListener listener) {
        this.communicator.addHeartbeatListener(listener);
    }

    public void removeHeartbeatListener(NGHeartbeatListener listener) {
        this.communicator.removeHeartbeatListener(listener);
    }
}

