/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.AliasManager;
import com.facebook.nailgun.NGConstants;
import com.facebook.nailgun.NGListeningAddress;
import com.facebook.nailgun.NGSecurityManager;
import com.facebook.nailgun.NGSessionPool;
import com.facebook.nailgun.NGUnixDomainServerSocket;
import com.facebook.nailgun.NGWin32NamedPipeServerSocket;
import com.facebook.nailgun.NailStats;
import com.facebook.nailgun.ThreadLocalInputStream;
import com.facebook.nailgun.ThreadLocalPrintStream;
import com.facebook.nailgun.builtins.DefaultNail;
import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(NGServer.class.getName());
    public static final int DEFAULT_SESSIONPOOLSIZE = 2;
    private final NGListeningAddress listeningAddress;
    private ServerSocket serversocket;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AliasManager aliasManager;
    private boolean allowNailsByClassName = true;
    private Class defaultNailClass = DefaultNail.class;
    private final NGSessionPool sessionPool;
    public final PrintStream out = System.out;
    public final PrintStream err = System.err;
    public final InputStream in = System.in;
    private final Map<String, NailStats> allNailStats;
    private SecurityManager originalSecurityManager = null;
    private final int heartbeatTimeoutMillis;

    public NGServer(InetAddress addr, int port, int sessionPoolSize, int timeoutMillis) {
        this(new NGListeningAddress(addr, port), sessionPoolSize, timeoutMillis);
    }

    public NGServer(InetAddress addr, int port) {
        this(new NGListeningAddress(addr, port), 2, 10000);
    }

    public NGServer() {
        this(new NGListeningAddress(null, 2113), 2, 10000);
    }

    public NGServer(NGListeningAddress listeningAddress, int sessionPoolSize, int timeoutMillis) {
        this.listeningAddress = listeningAddress;
        this.aliasManager = new AliasManager();
        this.allNailStats = new HashMap<String, NailStats>();
        this.sessionPool = new NGSessionPool(this, sessionPoolSize);
        this.heartbeatTimeoutMillis = timeoutMillis;
    }

    public void setAllowNailsByClassName(boolean allowNailsByClassName) {
        this.allowNailsByClassName = allowNailsByClassName;
    }

    public boolean allowsNailsByClassName() {
        return this.allowNailsByClassName;
    }

    public void setDefaultNailClass(Class defaultNailClass) {
        if (defaultNailClass == null) {
            throw new IllegalArgumentException("defaultNailClass");
        }
        this.defaultNailClass = defaultNailClass;
    }

    public Class getDefaultNailClass() {
        return this.defaultNailClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NailStats getOrCreateStatsFor(Class nailClass) {
        NailStats result;
        Map<String, NailStats> map = this.allNailStats;
        synchronized (map) {
            String nailClassName = nailClass.getName();
            result = this.allNailStats.get(nailClassName);
            if (result == null) {
                result = new NailStats(nailClassName);
                this.allNailStats.put(nailClassName, result);
            }
        }
        return result;
    }

    void nailStarted(Class nailClass) {
        NailStats stats = this.getOrCreateStatsFor(nailClass);
        stats.nailStarted();
    }

    void nailFinished(Class nailClass) {
        NailStats stats = this.getOrCreateStatsFor(nailClass);
        stats.nailFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NailStats> getNailStats() {
        TreeMap<String, NailStats> result = new TreeMap<String, NailStats>();
        Map<String, NailStats> map = this.allNailStats;
        synchronized (map) {
            for (Map.Entry<String, NailStats> entry : this.allNailStats.entrySet()) {
                result.put(entry.getKey(), (NailStats)entry.getValue().clone());
            }
        }
        return result;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public void signalExit() {
        ForkJoinPool.commonPool().submit(() -> this.shutdown());
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        try {
            this.serversocket.close();
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Exception closing server socket on Nailgun server shutdown", ex);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPort() {
        return this.serversocket == null ? this.listeningAddress.getInetPort() : this.serversocket.getLocalPort();
    }

    @Override
    public void run() {
        block17: {
            this.originalSecurityManager = System.getSecurityManager();
            System.setSecurityManager(new NGSecurityManager(this.originalSecurityManager));
            if (!(System.in instanceof ThreadLocalInputStream)) {
                System.setIn(new ThreadLocalInputStream(this.in));
            }
            if (!(System.out instanceof ThreadLocalPrintStream)) {
                System.setOut(new ThreadLocalPrintStream(this.out));
            }
            if (!(System.err instanceof ThreadLocalPrintStream)) {
                System.setErr(new ThreadLocalPrintStream(this.err));
            }
            try {
                String portDescription;
                if (this.listeningAddress.isInetAddress()) {
                    this.serversocket = this.listeningAddress.getInetAddress() == null ? new ServerSocket(this.listeningAddress.getInetPort()) : new ServerSocket(this.listeningAddress.getInetPort(), 0, this.listeningAddress.getInetAddress());
                } else if (Platform.isWindows()) {
                    boolean requireStrictLength = true;
                    this.serversocket = new NGWin32NamedPipeServerSocket(this.listeningAddress.getLocalAddress(), requireStrictLength);
                } else {
                    this.serversocket = new NGUnixDomainServerSocket(this.listeningAddress.getLocalAddress());
                }
                if (this.listeningAddress.isInetAddress() && this.listeningAddress.getInetPort() == 0) {
                    int runningPort = this.getPort();
                    while (runningPort == 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        runningPort = this.getPort();
                    }
                    portDescription = ", port " + runningPort;
                } else {
                    portDescription = "";
                }
                this.running.set(true);
                this.out.println("NGServer " + NGConstants.VERSION + " started on " + this.listeningAddress.toString() + portDescription + ".");
                while (!this.shutdown.get()) {
                    Socket socket = this.serversocket.accept();
                    this.sessionPool.take().run(socket);
                }
            }
            catch (IOException ex) {
                if (this.shutdown.get()) break block17;
                throw new RuntimeException(ex);
            }
        }
        try {
            this.sessionPool.shutdown();
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Exception shutting down Nailgun server", ex);
        }
        System.setIn(this.in);
        System.setOut(this.out);
        System.setErr(this.err);
        System.setSecurityManager(this.originalSecurityManager);
        this.running.set(false);
    }

    private static void usage() {
        System.err.println("Usage: java NGServer");
        System.err.println("   or: java NGServer port");
        System.err.println("   or: java NGServer IPAddress");
        System.err.println("   or: java NGServer IPAddress:port");
        System.err.println("   or: java NGServer IPAddress:port timeout");
    }

    public static void main(String[] args) throws NumberFormatException, UnknownHostException {
        NGListeningAddress listeningAddress;
        if (args.length > 2) {
            NGServer.usage();
            return;
        }
        int timeoutMillis = 10000;
        if (args.length != 0) {
            String[] argParts = args[0].split(":");
            String addrPart = null;
            String portPart = null;
            if (argParts.length == 2) {
                addrPart = argParts[0];
                portPart = argParts[1];
            } else if (argParts[0].indexOf(46) >= 0) {
                addrPart = argParts[0];
            } else {
                portPart = argParts[0];
            }
            listeningAddress = "local".equals(addrPart) && portPart != null ? new NGListeningAddress(portPart) : (addrPart != null && portPart != null ? new NGListeningAddress(InetAddress.getByName(addrPart), Integer.parseInt(portPart)) : (addrPart != null && portPart == null ? new NGListeningAddress(InetAddress.getByName(addrPart), 2113) : new NGListeningAddress(null, Integer.parseInt(portPart))));
            if (args.length == 2) {
                timeoutMillis = Integer.parseInt(args[1]);
            }
        } else {
            listeningAddress = new NGListeningAddress(null, 2113);
        }
        NGServer server = new NGServer(listeningAddress, 2, timeoutMillis);
        Thread t = new Thread(server);
        t.setName("NGServer(" + listeningAddress.toString() + ")");
        t.start();
        Runtime.getRuntime().addShutdownHook(new NGServerShutdowner(server));
    }

    public int getHeartbeatTimeout() {
        return this.heartbeatTimeoutMillis;
    }

    private static class NGServerShutdowner
    extends Thread {
        private final NGServer server;

        NGServerShutdowner(NGServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.shutdown();
            for (int count = 0; this.server.isRunning() && count < 50; ++count) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.server.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
            } else {
                System.out.println("NGServer shut down.");
            }
        }
    }
}

