/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.Alias;
import com.facebook.nailgun.CommandContext;
import com.facebook.nailgun.NGCommunicator;
import com.facebook.nailgun.NGContext;
import com.facebook.nailgun.NGExitException;
import com.facebook.nailgun.NGInputStream;
import com.facebook.nailgun.NGNailNotFoundException;
import com.facebook.nailgun.NGOutputStream;
import com.facebook.nailgun.NGServer;
import com.facebook.nailgun.NGSessionPool;
import com.facebook.nailgun.NonStaticNail;
import com.facebook.nailgun.ThreadLocalInputStream;
import com.facebook.nailgun.ThreadLocalPrintStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGSession
extends Thread {
    private static final Logger LOG = Logger.getLogger(NGSession.class.getName());
    private final NGServer server;
    private final NGSessionPool sessionPool;
    private final CommnunicatorCreator communicatorCreator;
    private final Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private final long instanceNumber;
    private final int heartbeatTimeoutMillis;
    private static AtomicLong instanceCounter = new AtomicLong(0L);
    private static final Class[] mainSignature = new Class[]{String[].class};
    private static final Class[] nailMainSignature = new Class[]{NGContext.class};
    public static volatile ClassLoader classLoader = null;

    NGSession(NGSessionPool sessionPool, NGServer server) {
        this(sessionPool, server, null);
    }

    NGSession(NGSessionPool sessionPool, NGServer server, CommnunicatorCreator communicatorCreator) {
        this.sessionPool = sessionPool;
        this.server = server;
        this.heartbeatTimeoutMillis = server.getHeartbeatTimeout();
        this.instanceNumber = instanceCounter.incrementAndGet();
        this.communicatorCreator = communicatorCreator != null ? communicatorCreator : socket -> new NGCommunicator(socket, this.heartbeatTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.nextSocket = null;
            this.lock.notifyAll();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket result;
        Object object = this.lock;
        synchronized (object) {
            result = this.nextSocket;
            while (!this.done && result == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.done = true;
                }
                result = this.nextSocket;
            }
            this.nextSocket = null;
        }
        if (result != null) {
            try {
                result.setSoTimeout(this.heartbeatTimeoutMillis);
            }
            catch (SocketException e) {
                return null;
            }
        }
        return result;
    }

    @Override
    public void run() {
        this.updateThreadName(null);
        LOG.log(Level.FINE, "NGSession {0} is waiting for first client to connect", this.instanceNumber);
        Socket socket = this.nextSocket();
        while (socket != null) {
            LOG.log(Level.FINE, "NGSession {0} accepted new connection", this.instanceNumber);
            try (NGCommunicator comm = this.communicatorCreator.get(socket);){
                this.runImpl(comm, socket);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Internal error in NGSession " + this.instanceNumber, t);
            }
            LOG.log(Level.FINEST, "NGSession {0} started cleanup", this.instanceNumber);
            if (System.in instanceof ThreadLocalInputStream) {
                ((ThreadLocalInputStream)System.in).init(null);
                ((ThreadLocalPrintStream)System.out).init(null);
                ((ThreadLocalPrintStream)System.err).init(null);
            }
            LOG.log(Level.FINE, "NGSession {0} is closing client socket", this.instanceNumber);
            try {
                socket.close();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Internal error closing socket", t);
            }
            this.updateThreadName(null);
            this.sessionPool.give(this);
            socket = this.nextSocket();
        }
        LOG.log(Level.FINE, "NGSession {0} stopped", this.instanceNumber);
    }

    private void runImpl(NGCommunicator comm, Socket socket) {
        try (NGInputStream in = new NGInputStream(comm);
             PrintStream out = new PrintStream(new NGOutputStream(comm, 49));
             PrintStream err = new PrintStream(new NGOutputStream(comm, 50));){
            Method mainMethod;
            Class<Object> cmdclass;
            if (System.in instanceof ThreadLocalInputStream) {
                ((ThreadLocalInputStream)System.in).init(in);
                ((ThreadLocalPrintStream)System.out).init(out);
                ((ThreadLocalPrintStream)System.err).init(err);
            }
            CommandContext cmdContext = comm.readCommandContext();
            String threadName = (socket.getInetAddress() == null ? "" : socket.getInetAddress().getHostAddress() + ": ") + cmdContext.getCommand();
            this.updateThreadName(threadName);
            try {
                Alias alias = this.server.getAliasManager().getAlias(cmdContext.getCommand());
                cmdclass = alias != null ? alias.getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(cmdContext.getCommand(), true, classLoader) : this.server.getDefaultNailClass());
            }
            catch (ClassNotFoundException ex) {
                throw new NGNailNotFoundException("Nail class not found: " + cmdContext.getCommand(), ex);
            }
            Object[] methodArgs = new Object[1];
            String[] cmdlineArgs = cmdContext.getCommandArguments().toArray(new String[cmdContext.getCommandArguments().size()]);
            boolean isStaticNail = true;
            Class<?>[] interfaces = cmdclass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals(NonStaticNail.class)) continue;
                isStaticNail = false;
                break;
            }
            if (!isStaticNail) {
                mainMethod = cmdclass.getMethod("nailMain", String[].class);
                methodArgs[0] = cmdlineArgs;
            } else {
                try {
                    mainMethod = cmdclass.getMethod("nailMain", nailMainSignature);
                    NGContext context = new NGContext();
                    context.setArgs(cmdlineArgs);
                    context.in = in;
                    context.out = out;
                    context.err = err;
                    context.setCommand(cmdContext.getCommand());
                    context.setNGServer(this.server);
                    context.setCommunicator(comm);
                    context.setEnv(cmdContext.getEnvironmentVariables());
                    context.setInetAddress(socket.getInetAddress());
                    context.setPort(socket.getPort());
                    context.setWorkingDirectory(cmdContext.getWorkingDirectory());
                    methodArgs[0] = context;
                }
                catch (NoSuchMethodException toDiscard) {
                    try {
                        mainMethod = cmdclass.getMethod("main", mainSignature);
                        methodArgs[0] = cmdlineArgs;
                    }
                    catch (NoSuchMethodException ex) {
                        throw new NGNailNotFoundException("Can't find nailMain or main functions in " + cmdclass.getName(), ex);
                    }
                }
            }
            this.server.nailStarted(cmdclass);
            try {
                mainMethod.invoke(isStaticNail ? null : cmdclass.newInstance(), methodArgs);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            finally {
                this.server.nailFinished(cmdclass);
            }
            comm.exit(0);
        }
        catch (NGExitException exitEx) {
            LOG.log(Level.INFO, "Nail cleanly exited with status {0}", exitEx.getStatus());
            comm.exit(exitEx.getStatus());
        }
        catch (NGNailNotFoundException notFoundEx) {
            LOG.log(Level.WARNING, "Nail not found", notFoundEx);
            comm.exit(898);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Nail raised unhandled exception", t);
            comm.exit(899);
        }
    }

    private void updateThreadName(String detail) {
        this.setName("NGSession " + this.instanceNumber + ": " + (detail == null ? "(idle)" : detail));
    }

    static {
        classLoader = NGSession.class.getClassLoader();
    }

    @FunctionalInterface
    public static interface CommnunicatorCreator {
        public NGCommunicator get(Socket var1) throws IOException;
    }
}

