/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGUnixDomainSocket;
import com.facebook.nailgun.NGUnixDomainSocketLibrary;
import com.sun.jna.LastErrorException;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class NGUnixDomainServerSocket
extends ServerSocket {
    private static final int DEFAULT_BACKLOG = 50;
    private final AtomicInteger fd;
    private final int backlog;
    private boolean isBound;
    private boolean isClosed;

    public NGUnixDomainServerSocket() throws IOException {
        this(50, null);
    }

    public NGUnixDomainServerSocket(int backlog) throws IOException {
        this(backlog, null);
    }

    public NGUnixDomainServerSocket(String path) throws IOException {
        this(50, path);
    }

    public NGUnixDomainServerSocket(int backlog, String path) throws IOException {
        try {
            this.fd = new AtomicInteger(NGUnixDomainSocketLibrary.socket(1, 1, 0));
            this.backlog = backlog;
            if (path != null) {
                this.bind(new NGUnixDomainServerSocketAddress(path));
            }
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void bind(SocketAddress endpoint) throws IOException {
        if (!(endpoint instanceof NGUnixDomainServerSocketAddress)) {
            throw new IllegalArgumentException("endpoint must be an instance of NGUnixDomainServerSocketAddress");
        }
        if (this.isBound) {
            throw new IllegalStateException("Socket is already bound");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        NGUnixDomainServerSocketAddress unEndpoint = (NGUnixDomainServerSocketAddress)endpoint;
        NGUnixDomainSocketLibrary.SockaddrUn address = new NGUnixDomainSocketLibrary.SockaddrUn(unEndpoint.getPath());
        try {
            int socketFd = this.fd.get();
            NGUnixDomainSocketLibrary.bind(socketFd, address, address.size());
            NGUnixDomainSocketLibrary.listen(socketFd, this.backlog);
            this.isBound = true;
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        NGUnixDomainServerSocket nGUnixDomainServerSocket = this;
        synchronized (nGUnixDomainServerSocket) {
            if (!this.isBound) {
                throw new IllegalStateException("Socket is not bound");
            }
            if (this.isClosed) {
                throw new IllegalStateException("Socket is already closed");
            }
        }
        try {
            NGUnixDomainSocketLibrary.SockaddrUn sockaddrUn = new NGUnixDomainSocketLibrary.SockaddrUn();
            IntByReference addressLen = new IntByReference();
            addressLen.setValue(sockaddrUn.size());
            int clientFd = NGUnixDomainSocketLibrary.accept(this.fd.get(), sockaddrUn, addressLen);
            return new NGUnixDomainSocket(clientFd);
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        try {
            int socketFd = this.fd.getAndSet(-1);
            if (Platform.isLinux()) {
                NGUnixDomainSocketLibrary.shutdown(socketFd, 2);
            }
            NGUnixDomainSocketLibrary.close(socketFd);
            this.isClosed = true;
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    public static class NGUnixDomainServerSocketAddress
    extends SocketAddress {
        private final String path;

        public NGUnixDomainServerSocketAddress(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

