/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGWin32NamedPipeLibrary;
import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;

public class NGWin32NamedPipeSocket
extends Socket {
    private static final NGWin32NamedPipeLibrary API = NGWin32NamedPipeLibrary.INSTANCE;
    static final boolean DEFAULT_REQUIRE_STRICT_LENGTH = false;
    private final WinNT.HANDLE handle;
    private final CloseCallback closeCallback;
    private final boolean requireStrictLength;
    private final InputStream is;
    private final OutputStream os;
    private final WinNT.HANDLE readerWaitable;
    private final WinNT.HANDLE writerWaitable;

    public NGWin32NamedPipeSocket(WinNT.HANDLE handle, CloseCallback closeCallback, boolean requireStrictLength) throws IOException {
        this.handle = handle;
        this.closeCallback = closeCallback;
        this.requireStrictLength = requireStrictLength;
        this.readerWaitable = API.CreateEvent(null, true, false, null);
        if (this.readerWaitable == null) {
            throw new IOException("CreateEvent() failed ");
        }
        this.writerWaitable = API.CreateEvent(null, true, false, null);
        if (this.writerWaitable == null) {
            throw new IOException("CreateEvent() failed ");
        }
        this.is = new NGWin32NamedPipeSocketInputStream(handle);
        this.os = new NGWin32NamedPipeSocketOutputStream(handle);
    }

    public NGWin32NamedPipeSocket(WinNT.HANDLE handle, CloseCallback closeCallback) throws IOException {
        this(handle, closeCallback, false);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void close() throws IOException {
        this.closeCallback.onNamedPipeSocketClose(this.handle);
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    private class NGWin32NamedPipeSocketOutputStream
    extends OutputStream {
        private final WinNT.HANDLE handle;

        NGWin32NamedPipeSocketOutputStream(WinNT.HANDLE handle) {
            this.handle = handle;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(0xFF & b)});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int lastError;
            ByteBuffer data = ByteBuffer.wrap(b, off, len);
            WinBase.OVERLAPPED olap = new WinBase.OVERLAPPED();
            olap.hEvent = NGWin32NamedPipeSocket.this.writerWaitable;
            olap.write();
            boolean immediate = API.WriteFile(this.handle, data, len, null, olap.getPointer());
            if (!immediate && (lastError = API.GetLastError()) != 997) {
                throw new IOException("WriteFile() failed: " + lastError);
            }
            IntByReference written = new IntByReference();
            if (!API.GetOverlappedResult(this.handle, olap.getPointer(), written, true)) {
                int lastError2 = API.GetLastError();
                throw new IOException("GetOverlappedResult() failed for write operation: " + lastError2);
            }
            if (written.getValue() != len) {
                throw new IOException("WriteFile() wrote less bytes than requested");
            }
        }
    }

    private class NGWin32NamedPipeSocketInputStream
    extends InputStream {
        private final WinNT.HANDLE handle;

        NGWin32NamedPipeSocketInputStream(WinNT.HANDLE handle) {
            this.handle = handle;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int result = this.read(b) == 0 ? -1 : 0xFF & b[0];
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int lastError;
            Memory readBuffer = new Memory((long)len);
            WinBase.OVERLAPPED olap = new WinBase.OVERLAPPED();
            olap.hEvent = NGWin32NamedPipeSocket.this.readerWaitable;
            olap.write();
            boolean immediate = API.ReadFile(this.handle, readBuffer, len, null, olap.getPointer());
            if (!immediate && (lastError = API.GetLastError()) != 997) {
                throw new IOException("ReadFile() failed: " + lastError);
            }
            IntByReference r = new IntByReference();
            if (!API.GetOverlappedResult(this.handle, olap.getPointer(), r, true)) {
                int lastError2 = API.GetLastError();
                throw new IOException("GetOverlappedResult() failed for read operation: " + lastError2);
            }
            int actualLen = r.getValue();
            if (NGWin32NamedPipeSocket.this.requireStrictLength && actualLen != len) {
                throw new IOException("ReadFile() read less bytes than requested: expected " + len + " bytes, but read " + actualLen + " bytes");
            }
            byte[] byteArray = readBuffer.getByteArray(0L, actualLen);
            System.arraycopy(byteArray, 0, b, off, actualLen);
            return actualLen;
        }
    }

    static interface CloseCallback {
        public void onNamedPipeSocketClose(WinNT.HANDLE var1) throws IOException;
    }
}

