/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFuture;

public abstract class AbstractClientConnector<T extends NiftyClientChannel>
implements NiftyClientConnector<T> {
    protected final SocketAddress address;
    private final TDuplexProtocolFactory protocolFactory;

    public AbstractClientConnector(SocketAddress address, TDuplexProtocolFactory protocolFactory) {
        this.address = address;
        this.protocolFactory = protocolFactory;
    }

    @Override
    public ChannelFuture connect(ClientBootstrap bootstrap) {
        return bootstrap.connect(this.address);
    }

    public String toString() {
        return this.address.toString();
    }

    protected TDuplexProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    protected static SocketAddress toSocketAddress(HostAndPort address) {
        return new InetSocketAddress(address.getHostText(), address.getPort());
    }

    protected static TDuplexProtocolFactory defaultProtocolFactory() {
        return TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TBinaryProtocol.Factory());
    }
}

