/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.AbstractClientChannel;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.Timer;

@NotThreadSafe
public class HttpClientChannel
extends AbstractClientChannel {
    private final Channel underlyingNettyChannel;
    private final String hostName;
    private Map<String, String> headerDictionary;
    private final String endpointUri;

    protected HttpClientChannel(Channel channel, Timer timer, TDuplexProtocolFactory protocolFactory, String hostName, String endpointUri) {
        super(channel, timer, protocolFactory);
        this.underlyingNettyChannel = channel;
        this.hostName = hostName;
        this.endpointUri = endpointUri;
    }

    @Override
    public Channel getNettyChannel() {
        return this.underlyingNettyChannel;
    }

    @Override
    protected ChannelBuffer extractResponse(Object message) throws TTransportException {
        if (!(message instanceof HttpResponse)) {
            return null;
        }
        HttpResponse httpResponse = (HttpResponse)message;
        if (!httpResponse.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new TTransportException("HTTP response had non-OK status: " + httpResponse.getStatus().toString());
        }
        ChannelBuffer content = httpResponse.getContent();
        if (!content.readable()) {
            return null;
        }
        return content;
    }

    @Override
    protected ChannelFuture writeRequest(ChannelBuffer request) {
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.endpointUri);
        httpRequest.headers().add("Host", (Object)this.hostName);
        httpRequest.headers().add("Content-Length", (Object)request.readableBytes());
        httpRequest.headers().add("Content-Type", (Object)"application/x-thrift");
        httpRequest.headers().add("Accept", (Object)"application/x-thrift");
        httpRequest.headers().add("User-Agent", (Object)"Java/Swift-HttpThriftClientChannel");
        if (this.headerDictionary != null) {
            for (Map.Entry<String, String> entry : this.headerDictionary.entrySet()) {
                httpRequest.headers().add(entry.getKey(), (Object)entry.getValue());
            }
        }
        httpRequest.setContent(request);
        return this.underlyingNettyChannel.write((Object)httpRequest);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headerDictionary = headers;
    }
}

