/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.core.NettyConfigBuilderBase;
import com.facebook.nifty.core.NiftyTimer;
import com.facebook.nifty.ssl.SslClientConfiguration;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.util.Timer;

public class NettyClientConfigBuilder
extends NettyConfigBuilderBase<NettyClientConfigBuilder> {
    private HostAndPort defaultSocksProxyAddress = null;
    private SslClientConfiguration sslClientConfiguration;
    private final NioSocketChannelConfig socketChannelConfig = (NioSocketChannelConfig)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{NioSocketChannelConfig.class}, (InvocationHandler)new NettyConfigBuilderBase.Magic((NettyConfigBuilderBase)this, ""));

    @Inject
    public NettyClientConfigBuilder() {
        this.getSocketChannelConfig().setTcpNoDelay(true);
    }

    public NioSocketChannelConfig getSocketChannelConfig() {
        return this.socketChannelConfig;
    }

    public NettyClientConfigBuilder setDefaultSocksProxyAddress(HostAndPort defaultSocksProxyAddress) {
        this.defaultSocksProxyAddress = defaultSocksProxyAddress;
        return this;
    }

    public NettyClientConfigBuilder setSSLClientConfiguration(SslClientConfiguration sslClientConfiguration) {
        this.sslClientConfiguration = sslClientConfiguration;
        return this;
    }

    public NettyClientConfig build() {
        Timer timer = this.getTimer();
        ExecutorService bossExecutor = this.getBossExecutor();
        int bossThreadCount = this.getBossThreadCount();
        ExecutorService workerExecutor = this.getWorkerExecutor();
        int workerThreadCount = this.getWorkerThreadCount();
        return new NettyClientConfig(this.getBootstrapOptions(), this.defaultSocksProxyAddress, (Timer)(timer != null ? timer : new NiftyTimer(this.threadNamePattern(""))), bossExecutor != null ? bossExecutor : this.buildDefaultBossExecutor(), bossThreadCount, workerExecutor != null ? workerExecutor : this.buildDefaultWorkerExecutor(), workerThreadCount, this.sslClientConfiguration);
    }

    private ExecutorService buildDefaultBossExecutor() {
        return Executors.newCachedThreadPool(this.renamingDaemonThreadFactory(this.threadNamePattern("-boss-%s")));
    }

    private ExecutorService buildDefaultWorkerExecutor() {
        return Executors.newCachedThreadPool(this.renamingDaemonThreadFactory(this.threadNamePattern("-worker-%s")));
    }

    private String threadNamePattern(String suffix) {
        String niftyName = this.getNiftyName();
        return "nifty-client" + (Strings.isNullOrEmpty((String)niftyName) ? "" : "-" + niftyName) + suffix;
    }

    private ThreadFactory renamingDaemonThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build();
    }
}

