/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.AbstractClientConnector;
import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.TimeoutHandler;
import com.facebook.nifty.client.UnframedClientChannel;
import com.facebook.nifty.core.ThriftUnframedDecoder;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public class UnframedClientConnector
extends AbstractClientConnector<UnframedClientChannel> {
    public UnframedClientConnector(InetSocketAddress address) {
        this(address, UnframedClientConnector.defaultProtocolFactory());
    }

    public UnframedClientConnector(HostAndPort address) {
        this(address, UnframedClientConnector.defaultProtocolFactory());
    }

    public UnframedClientConnector(InetSocketAddress address, TDuplexProtocolFactory protocolFactory) {
        super(address, protocolFactory);
    }

    public UnframedClientConnector(HostAndPort address, TDuplexProtocolFactory protocolFactory) {
        super(UnframedClientConnector.toSocketAddress(address), protocolFactory);
    }

    @Override
    public UnframedClientChannel newThriftClientChannel(Channel nettyChannel, NettyClientConfig clientConfig) {
        UnframedClientChannel channel = new UnframedClientChannel(nettyChannel, clientConfig.getTimer(), this.getProtocolFactory());
        ChannelPipeline cp = nettyChannel.getPipeline();
        TimeoutHandler.addToPipeline(cp);
        cp.addLast("thriftHandler", (ChannelHandler)channel);
        return channel;
    }

    @Override
    public ChannelPipelineFactory newChannelPipelineFactory(int maxFrameSize, final NettyClientConfig clientConfig) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                TimeoutHandler.addToPipeline(cp);
                cp.addLast("thriftUnframedDecoder", (ChannelHandler)new ThriftUnframedDecoder());
                if (clientConfig.sslClientConfiguration() != null) {
                    cp.addFirst("ssl", (ChannelHandler)clientConfig.sslClientConfiguration().createHandler(UnframedClientConnector.this.address));
                }
                return cp;
            }
        };
    }
}

