/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client.socks;

import com.facebook.nifty.client.socks.SettableChannelFuture;
import com.facebook.nifty.client.socks.Socks4HandshakeHandler;
import com.facebook.nifty.client.socks.SocksProtocols;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FixedLengthFrameDecoder;

public class Socks4ClientBootstrap
extends ClientBootstrap {
    static final String FRAME_DECODER = "frameDecoder";
    static final String HANDSHAKE = "handshake";
    private final InetSocketAddress socksProxyAddr;

    public Socks4ClientBootstrap(ChannelFactory channelFactory, InetSocketAddress socksProxyAddr) {
        super(channelFactory);
        this.socksProxyAddr = socksProxyAddr;
    }

    public Socks4ClientBootstrap(InetSocketAddress socksProxyAddr) {
        this.socksProxyAddr = socksProxyAddr;
        super.setPipeline(this.getPipeline());
    }

    public ChannelPipelineFactory getPipelineFactory() {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast(Socks4ClientBootstrap.FRAME_DECODER, (ChannelHandler)new FixedLengthFrameDecoder(8));
                cp.addLast(Socks4ClientBootstrap.HANDSHAKE, (ChannelHandler)new Socks4HandshakeHandler(Socks4ClientBootstrap.super.getPipelineFactory()));
                return cp;
            }
        };
    }

    public ChannelFuture connect(final SocketAddress remoteAddress) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("expecting InetSocketAddress");
        }
        final SettableChannelFuture settableChannelFuture = new SettableChannelFuture();
        super.connect((SocketAddress)this.socksProxyAddr).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                settableChannelFuture.setChannel(future.getChannel());
                if (future.isSuccess()) {
                    Socks4ClientBootstrap.socksConnect(future.getChannel(), (InetSocketAddress)remoteAddress).addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture innerFuture) throws Exception {
                            if (innerFuture.isSuccess()) {
                                settableChannelFuture.setSuccess();
                            } else {
                                settableChannelFuture.setFailure(innerFuture.getCause());
                            }
                        }
                    });
                } else {
                    settableChannelFuture.setFailure(future.getCause());
                }
            }
        });
        return settableChannelFuture;
    }

    private static ChannelFuture socksConnect(Channel channel, InetSocketAddress remoteAddress) {
        channel.write((Object)Socks4ClientBootstrap.createHandshake(remoteAddress));
        return ((Socks4HandshakeHandler)channel.getPipeline().get(HANDSHAKE)).getChannelFuture();
    }

    private static ChannelBuffer createHandshake(InetSocketAddress address) {
        if (address.getAddress() instanceof Inet4Address) {
            return SocksProtocols.createSocks4packet(address.getAddress(), address.getPort());
        }
        if (address.getAddress() != null) {
            return SocksProtocols.createSock4aPacket(InetAddresses.toAddrString((InetAddress)address.getAddress()), address.getPort());
        }
        if (address.getHostName() != null) {
            return SocksProtocols.createSock4aPacket(address.getHostName(), address.getPort());
        }
        throw new IllegalArgumentException("Invalid Address " + address);
    }
}

