/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client.socks;

import com.google.common.base.Charsets;
import java.net.InetAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class SocksProtocols {
    public static final int SOCKS_VERSION_4 = 4;
    public static final int CONNECT = 1;
    public static final int REQUEST_GRANTED = 90;
    public static final int REQUEST_FAILED = 91;
    public static final int REQUEST_FAILED_NO_IDENTD = 92;
    public static final int REQUEST_FAILED_USERID_NOT_CONFIRMED = 93;

    public static ChannelBuffer createSocks4packet(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        ChannelBuffer handshake = ChannelBuffers.dynamicBuffer((int)9);
        handshake.writeByte(4);
        handshake.writeByte(1);
        handshake.writeShort(port);
        handshake.writeBytes(address.getAddress());
        handshake.writeByte(0);
        return handshake;
    }

    public static ChannelBuffer createSock4aPacket(String hostName, int port) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName is null");
        }
        byte[] hostNameBytes = hostName.getBytes(Charsets.ISO_8859_1);
        ChannelBuffer handshake = ChannelBuffers.dynamicBuffer((int)(10 + hostNameBytes.length));
        handshake.writeByte(4);
        handshake.writeByte(1);
        handshake.writeShort(port);
        handshake.writeByte(0);
        handshake.writeByte(0);
        handshake.writeByte(0);
        handshake.writeByte(1);
        handshake.writeByte(0);
        handshake.writeBytes(hostNameBytes);
        handshake.writeByte(0);
        return handshake;
    }
}

