/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.ssl;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.SSL;
import org.jboss.netty.handler.ssl.OpenSsl;
import org.jboss.netty.util.internal.NativeLibraryLoader;

public class NettyTcNativeLoader {
    private static final String LINUX = "linux";
    private static final String UNKNOWN = "unknown";
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static void ensureAvailable() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    private static void loadTcNative() {
        String os = NettyTcNativeLoader.normalizeOs(System.getProperty("os.name", ""));
        String arch = NettyTcNativeLoader.normalizeArch(System.getProperty("os.arch", ""));
        LinkedHashSet<String> libNames = new LinkedHashSet<String>(3);
        libNames.add("netty-tcnative-" + os + '-' + arch);
        if (LINUX.equalsIgnoreCase(os)) {
            libNames.add("netty-tcnative-" + os + '-' + arch + "-fedora");
        }
        libNames.add("netty-tcnative");
        boolean loaded = false;
        Throwable lastException = null;
        for (String libName : libNames) {
            try {
                NativeLibraryLoader.load((String)libName, (ClassLoader)SSL.class.getClassLoader());
                loaded = true;
                break;
            }
            catch (Throwable t) {
                lastException = t;
            }
        }
        if (!loaded) {
            throw Throwables.propagate(lastException);
        }
        try {
            NettyTcNativeLoader.overrideExceptionValue();
            Library.initialize((String)"provided");
            SSL.initialize(null);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void overrideExceptionValue() {
        boolean bl;
        Field exceptionField = null;
        Field modifiersField = null;
        int originalModifiers = 0;
        boolean setModifiers = false;
        try {
            exceptionField = OpenSsl.class.getDeclaredField("UNAVAILABILITY_CAUSE");
            exceptionField.setAccessible(true);
            modifiersField = exceptionField.getClass().getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            originalModifiers = modifiersField.getInt(exceptionField);
            modifiersField.setInt(exceptionField, originalModifiers & 0xFFFFFFEF);
            setModifiers = true;
            exceptionField.set(null, null);
            if (exceptionField == null) return;
            bl = modifiersField != null;
        }
        catch (Throwable t) {
            try {
                throw Throwables.propagate((Throwable)t);
            }
            catch (Throwable throwable) {
                if (exceptionField == null) throw throwable;
                if (!(modifiersField != null & setModifiers)) throw throwable;
                try {
                    modifiersField.setInt(exceptionField, originalModifiers);
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    return;
                }
            }
        }
        if (!(bl & setModifiers)) return;
        try {
            modifiersField.setInt(exceptionField, originalModifiers);
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
    }

    private static String normalizeOs(String value) {
        if ((value = NettyTcNativeLoader.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith(LINUX)) {
            return LINUX;
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = NettyTcNativeLoader.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    static {
        Throwable cause = null;
        try {
            NettyTcNativeLoader.loadTcNative();
        }
        catch (Throwable t) {
            cause = t;
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

