/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.ssl;

import com.facebook.nifty.ssl.BetterSslHandler;
import com.facebook.nifty.ssl.SslDefaults;
import com.facebook.nifty.ssl.SslHandlerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SessionTicketKey;
import org.jboss.netty.handler.ssl.OpenSslEngine;
import org.jboss.netty.handler.ssl.SslBufferPool;
import org.jboss.netty.handler.ssl.SslHandler;

public final class NiftyOpenSslServerContext
implements SslHandlerFactory {
    private static final String IGNORABLE_ERROR_PREFIX = "error:00000000:";
    private final long aprPool;
    private final List<String> ciphers = new ArrayList<String>();
    private final List<String> unmodifiableCiphers = Collections.unmodifiableList(this.ciphers);
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final List<String> nextProtocols;
    private final SslBufferPool bufferPool = NiftyOpenSslServerContext.newBufferPool();
    private final long ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NiftyOpenSslServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, int sslVersion, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        boolean bl;
        if (certChainFile == null) {
            throw new NullPointerException("certChainFile");
        }
        if (!certChainFile.isFile()) {
            throw new IllegalArgumentException("certChainFile is not a file: " + certChainFile);
        }
        if (keyFile == null) {
            throw new NullPointerException("keyPath");
        }
        if (!keyFile.isFile()) {
            throw new IllegalArgumentException("keyPath is not a file: " + keyFile);
        }
        if (ciphers == null) {
            ciphers = SslDefaults.SERVER_DEFAULTS;
        }
        if (keyPassword == null) {
            keyPassword = "";
        }
        if (nextProtocols == null) {
            nextProtocols = Collections.emptyList();
        }
        for (String string : ciphers) {
            if (string == null) break;
            this.ciphers.add(string);
        }
        ArrayList<String> nextProtoList = new ArrayList<String>();
        for (String p : nextProtocols) {
            if (p == null) break;
            nextProtoList.add(p);
        }
        this.nextProtocols = Collections.unmodifiableList(nextProtoList);
        this.aprPool = Pool.create((long)0L);
        boolean bl2 = false;
        try {
            Class<NiftyOpenSslServerContext> clazz = NiftyOpenSslServerContext.class;
            synchronized (NiftyOpenSslServerContext.class) {
                String error;
                try {
                    this.ctx = SSLContext.make((long)this.aprPool, (int)sslVersion, (int)1);
                }
                catch (Exception e) {
                    throw new SSLException("failed to create an SSL_CTX", e);
                }
                SSLContext.setOptions((long)this.ctx, (int)4095);
                SSLContext.setOptions((long)this.ctx, (int)0x1000000);
                SSLContext.setOptions((long)this.ctx, (int)0x2000000);
                SSLContext.setOptions((long)this.ctx, (int)0x400000);
                SSLContext.setOptions((long)this.ctx, (int)524288);
                SSLContext.setOptions((long)this.ctx, (int)0x100000);
                SSLContext.setOptions((long)this.ctx, (int)65536);
                SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | 2));
                try {
                    StringBuilder cipherBuf = new StringBuilder();
                    for (String c3 : this.ciphers) {
                        cipherBuf.append(c3);
                        cipherBuf.append(':');
                    }
                    cipherBuf.setLength(cipherBuf.length() - 1);
                    SSLContext.setCipherSuite((long)this.ctx, (String)cipherBuf.toString());
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set cipher suite: " + this.ciphers, e);
                }
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                try {
                    if (!SSLContext.setCertificate((long)this.ctx, (String)certChainFile.getPath(), (String)keyFile.getPath(), (String)keyPassword, (int)0)) {
                        throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile + " (" + SSL.getLastError() + ')');
                    }
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile, e);
                }
                if (!SSLContext.setCertificateChainFile((long)this.ctx, (String)certChainFile.getPath(), (boolean)true) && !(error = SSL.getLastError()).startsWith(IGNORABLE_ERROR_PREFIX)) {
                    throw new SSLException("failed to set certificate chain: " + certChainFile + " (" + SSL.getLastError() + ')');
                }
                if (!nextProtoList.isEmpty()) {
                    StringBuilder nextProtocolBuf = new StringBuilder();
                    for (String p2 : nextProtoList) {
                        nextProtocolBuf.append(p2);
                        nextProtocolBuf.append(',');
                    }
                    nextProtocolBuf.setLength(nextProtocolBuf.length() - 1);
                    SSLContext.setNextProtos((long)this.ctx, (String)nextProtocolBuf.toString());
                }
                if (this.nextProtocols != null && !this.nextProtocols.isEmpty()) {
                    String[] alpnArray = this.nextProtocols.toArray(new String[0]);
                    SSLContext.setAlpnProtos((long)this.ctx, (String[])alpnArray, (int)1);
                }
                if (sessionCacheSize > 0L) {
                    this.sessionCacheSize = sessionCacheSize;
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                } else {
                    this.sessionCacheSize = sessionCacheSize = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                }
                if (sessionTimeout > 0L) {
                    this.sessionTimeout = sessionTimeout;
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                } else {
                    this.sessionTimeout = sessionTimeout = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                }
                // ** MonitorExit[var13_14] (shouldn't be in output)
                bl = true;
            }
        }
        finally {
            if (!bl) {
                this.destroyPools();
            }
        }
        {
            return;
        }
    }

    private static SslBufferPool newBufferPool() {
        return new SslBufferPool(true, true);
    }

    public List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    public long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public long sessionTimeout() {
        return this.sessionTimeout;
    }

    public List<String> nextProtocols() {
        return this.nextProtocols;
    }

    public long context() {
        return this.ctx;
    }

    public SSLEngine newEngine() {
        if (this.nextProtocols.isEmpty()) {
            return new OpenSslEngine(this.ctx, this.bufferPool, null);
        }
        return new OpenSslEngine(this.ctx, this.bufferPool, this.nextProtocols.get(this.nextProtocols.size() - 1));
    }

    public void setTicketKeys(SessionTicketKey[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        SSLContext.setSessionTicketKeys((long)this.ctx, (SessionTicketKey[])keys);
    }

    public void setSessionIdContext(byte[] sessionIdContext) {
        SSLContext.setSessionIdContext((long)this.ctx, (byte[])sessionIdContext);
    }

    public void setSessionCacheTimeout(long sessionTimeoutSeconds) {
        SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeoutSeconds);
    }

    public SslHandler newHandler() {
        BetterSslHandler handler = new BetterSslHandler(this.newEngine(), this.bufferPool);
        handler.setCloseOnSSLException(true);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Class<NiftyOpenSslServerContext> clazz = NiftyOpenSslServerContext.class;
        synchronized (NiftyOpenSslServerContext.class) {
            if (this.ctx != 0L) {
                SSLContext.free((long)this.ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.destroyPools();
            return;
        }
    }

    private void destroyPools() {
        if (this.aprPool != 0L) {
            Pool.destroy((long)this.aprPool);
        }
    }
}

