/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.ssl;

import com.facebook.nifty.ssl.NettyTcNativeLoader;
import com.facebook.nifty.ssl.NiftyOpenSslServerContext;
import com.facebook.nifty.ssl.SslDefaults;
import com.facebook.nifty.ssl.SslHandlerFactory;
import com.facebook.nifty.ssl.SslServerConfiguration;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import javax.net.ssl.SSLException;
import org.apache.tomcat.jni.SessionTicketKey;

public class OpenSslServerConfiguration
extends SslServerConfiguration {
    public final SessionTicketKey[] ticketKeys;
    public final byte[] sessionContext;
    public final long sessionTimeoutSeconds;
    public final SSLVersion sslVersion;
    public final Iterable<String> nextProtocols;

    private OpenSslServerConfiguration(Builder builder) {
        super((SslServerConfiguration.BuilderBase)builder);
        this.ticketKeys = builder.ticketKeys;
        this.sessionContext = builder.sessionContext.getBytes();
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.sslVersion = builder.sslVersion;
        this.nextProtocols = builder.nextProtocols;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected SslHandlerFactory createSslHandlerFactory() {
        NettyTcNativeLoader.ensureAvailable();
        try {
            int sslVersionInt = 30;
            if (this.sslVersion == SSLVersion.TLS1_2) {
                sslVersionInt = 16;
            }
            NiftyOpenSslServerContext serverContext = new NiftyOpenSslServerContext(this.certFile, this.keyFile, null, this.ciphers, sslVersionInt, this.nextProtocols, 0L, 0L);
            if (this.ticketKeys != null) {
                serverContext.setTicketKeys(this.ticketKeys);
            }
            serverContext.setSessionIdContext(this.sessionContext);
            serverContext.setSessionCacheTimeout(this.sessionTimeoutSeconds);
            return serverContext;
        }
        catch (SSLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class Builder
    extends SslServerConfiguration.BuilderBase<Builder> {
        public SessionTicketKey[] ticketKeys;
        public String sessionContext = "thrift";
        public long sessionTimeoutSeconds = 86400L;
        public SSLVersion sslVersion = SSLVersion.TLS1_2;
        public Iterable<String> nextProtocols = ImmutableList.of((Object)"thrift");

        public Builder() {
            this.ciphers = SslDefaults.SERVER_DEFAULTS;
        }

        public Builder ticketKeys(SessionTicketKey[] ticketKeys) {
            this.ticketKeys = ticketKeys;
            return this;
        }

        public Builder nextProtocols(Iterable<String> nextProtocols) {
            this.nextProtocols = nextProtocols;
            return this;
        }

        public Builder sessionContext(String sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public Builder sessionTimeoutSeconds(long sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public Builder sslVersion(SSLVersion sslVersion) {
            this.sslVersion = sslVersion;
            return this;
        }

        protected SslServerConfiguration createServerConfiguration() {
            OpenSslServerConfiguration sslServerConfiguration = new OpenSslServerConfiguration(this);
            sslServerConfiguration.initializeServerContext();
            return sslServerConfiguration;
        }
    }

    public static enum SSLVersion {
        TLS,
        TLS1_2;

    }
}

