/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.base.type;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModeSetting
implements Parcelable {
    private static final Set<String> SUPPORTED_MODE_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ModeSetting_DefaultAuto", "ModeSetting_Fixed", "ModeSetting_Meeting", "ModeSetting_Desk")));
    private final String mId;
    private final Bundle mData;
    public static final Parcelable.Creator<ModeSetting> CREATOR = new Parcelable.Creator<ModeSetting>(){

        public ModeSetting createFromParcel(Parcel in) {
            return new ModeSetting(in);
        }

        public ModeSetting[] newArray(int size) {
            return new ModeSetting[size];
        }
    };

    public static Set<String> supportedModeIds() {
        return SUPPORTED_MODE_IDS;
    }

    public ModeSetting(String id, Bundle data) {
        this.mId = id;
        this.mData = data;
    }

    public ModeSetting(String id) {
        this(id, ModeSetting.newBundle());
    }

    protected ModeSetting(Parcel in) {
        this(in.readString(), in.readBundle(ModeSetting.class.getClassLoader()));
    }

    public String getId() {
        return this.mId;
    }

    public Bundle getData() {
        return this.mData;
    }

    private static Bundle newBundle() {
        return new Bundle(ModeSetting.class.getClassLoader());
    }

    private static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    private static void checkMode(ModeSetting mode, String expectedMode) {
        if (!mode.getId().equals(expectedMode)) {
            throw new IllegalArgumentException("Incompatible mode: " + mode);
        }
    }

    private static void checkKeyExists(ModeSetting mode, String key) {
        if (!mode.getData().containsKey(key)) {
            throw new IllegalArgumentException("Missing key: " + key);
        }
    }

    @Nullable
    private static List<RectF> deepCopy(@Nullable List<RectF> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RectF> copied = new ArrayList<RectF>(list.size());
        for (RectF rectF : list) {
            copied.add(new RectF(rectF));
        }
        return copied;
    }

    @Nullable
    private static <T> ArrayList<T> toArrayList(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<T>(list);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeBundle(this.mData);
    }

    public int describeContents() {
        return 0;
    }

    public static final class BasicSpotlight {
        public static final String ID = "ModeSetting_BasicSpotlight";

        public static ModeSetting create() {
            return new ModeSetting(ID);
        }

        private BasicSpotlight() {
        }
    }

    public static final class Desk {
        private static final String TAG = "ModeSetting.Desk";
        public static final String ID = "ModeSetting_Desk";
        public static final String ADDITIONAL_STABLE_FRAMING_TIGHTNESS = "additional_stable_framing_tightness";
        public static final String TRACKING_RESPONSE_DELAY_PERCENTAGE = "tracking_response_delay_percentage";
        public static final String TRACKING_SENSITIVITY_PERCENTAGE = "tracking_sensitivity_percentage";
        public static final String TRANSITION_SPEED_PERCENTAGE = "transition_speed_percentage";

        private Desk() {
        }

        public static ModeSetting create() {
            return new ModeSetting(ID);
        }

        @Nullable
        public static Float readAdditionalStableFramingTightness(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            try {
                ModeSetting.checkKeyExists(mode, ADDITIONAL_STABLE_FRAMING_TIGHTNESS);
            }
            catch (IllegalArgumentException e) {
                Log.i((String)TAG, (String)"Client did not provide additionalStableFramingTightness, using mc default values in director");
                return null;
            }
            return Float.valueOf(mode.getData().getFloat(ADDITIONAL_STABLE_FRAMING_TIGHTNESS));
        }

        @Nullable
        public static Float readTrackingResponseDelayPercentage(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            try {
                ModeSetting.checkKeyExists(mode, TRACKING_RESPONSE_DELAY_PERCENTAGE);
            }
            catch (IllegalArgumentException e) {
                Log.i((String)TAG, (String)"Client did not provide trackingResponseDelayPercentage, using mc default values in director");
                return null;
            }
            return Float.valueOf(mode.getData().getFloat(TRACKING_RESPONSE_DELAY_PERCENTAGE));
        }

        @Nullable
        public static Float readTrackingSensitivityPercentage(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            try {
                ModeSetting.checkKeyExists(mode, TRACKING_SENSITIVITY_PERCENTAGE);
            }
            catch (IllegalArgumentException e) {
                Log.i((String)TAG, (String)"Client did not provide trackingSensitivityPercentage, using mc default values in director");
                return null;
            }
            return Float.valueOf(mode.getData().getFloat(TRACKING_SENSITIVITY_PERCENTAGE));
        }

        @Nullable
        public static Float readTransitionSpeedPercentage(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            try {
                ModeSetting.checkKeyExists(mode, TRANSITION_SPEED_PERCENTAGE);
            }
            catch (IllegalArgumentException e) {
                Log.i((String)TAG, (String)"Client did not provide additionalStableFramingTightness, using mc default values in director");
                return null;
            }
            return Float.valueOf(mode.getData().getFloat(TRANSITION_SPEED_PERCENTAGE));
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Float mAdditionalStableFramingTightness;
            @Nullable
            private Float mTrackingResponseDelayPercentage;
            @Nullable
            private Float mTrackingSensitivityPercentage;
            @Nullable
            private Float mTransitionSpeedPercentage;

            private Builder() {
            }

            public Builder setAdditionalStableFramingTightness(@Nullable Float additionalStableFramingTightness) {
                this.mAdditionalStableFramingTightness = additionalStableFramingTightness;
                return this;
            }

            public Builder setTrackingResponseDelayPercentage(@Nullable Float trackingResponseDelayPercentage) {
                this.mTrackingResponseDelayPercentage = trackingResponseDelayPercentage;
                return this;
            }

            public Builder setTrackingSensitivityPercentage(@Nullable Float trackingSensitivityPercentage) {
                this.mTrackingSensitivityPercentage = trackingSensitivityPercentage;
                return this;
            }

            public Builder setTransitionSpeedPercentage(@Nullable Float transitionSpeedPercentage) {
                this.mTransitionSpeedPercentage = transitionSpeedPercentage;
                return this;
            }

            public ModeSetting build() {
                Bundle bundle = ModeSetting.newBundle();
                if (this.mAdditionalStableFramingTightness != null) {
                    bundle.putFloat(Desk.ADDITIONAL_STABLE_FRAMING_TIGHTNESS, this.mAdditionalStableFramingTightness.floatValue());
                }
                if (this.mTrackingResponseDelayPercentage != null) {
                    bundle.putFloat(Desk.TRACKING_RESPONSE_DELAY_PERCENTAGE, this.mTrackingResponseDelayPercentage.floatValue());
                }
                if (this.mTrackingSensitivityPercentage != null) {
                    bundle.putFloat(Desk.TRACKING_SENSITIVITY_PERCENTAGE, this.mTrackingSensitivityPercentage.floatValue());
                }
                if (this.mTransitionSpeedPercentage != null) {
                    bundle.putFloat(Desk.TRANSITION_SPEED_PERCENTAGE, this.mTransitionSpeedPercentage.floatValue());
                }
                return new ModeSetting(Desk.ID, bundle);
            }
        }
    }

    public static final class Meeting {
        public static final String ID = "ModeSetting_Meeting";

        private Meeting() {
        }

        public static ModeSetting create() {
            return new ModeSetting(ID);
        }
    }

    public static final class Fixed {
        public static final String ID = "ModeSetting_Fixed";
        public static final String CAMERA_RELATIVE_CROP_CENTER_X_KEY = "camera.relative_crop_center_x";
        public static final String CAMERA_RELATIVE_CROP_CENTER_Y_KEY = "camera.relative_crop_center_y";
        public static final String CAMERA_RELATIVE_CROP_SCALE_KEY = "camera.relative_crop_scale";
        public static final String CAMERA_RELATIVE_EXPOSURE_REGION_KEY = "camera.relative_exposure_region";
        public static final String CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY = "camera.relative_face_metering_regions";

        private Fixed() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static float readRelativeCropCenterX(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_CENTER_X_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_CENTER_X_KEY);
        }

        public static float readRelativeCropCenterY(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_CENTER_Y_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_CENTER_Y_KEY);
        }

        public static float readRelativeCropScale(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_SCALE_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_SCALE_KEY);
        }

        @Nullable
        public static RectF readRelativeExposureRegion(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_EXPOSURE_REGION_KEY);
            return (RectF)mode.getData().getParcelable(CAMERA_RELATIVE_EXPOSURE_REGION_KEY);
        }

        @Nullable
        public static List<RectF> readRelativeFaceMeteringRegions(ModeSetting mode) {
            ModeSetting.checkMode(mode, ID);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY);
            return mode.getData().getParcelableArrayList(CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY);
        }

        public static final class Builder {
            private float mRelativeCameraCropCenterX = Float.NaN;
            private float mRelativeCameraCropCenterY = Float.NaN;
            private float mRelativeCameraCropScale = Float.NaN;
            @Nullable
            private RectF mRelativeCameraExposureRegion;
            @Nullable
            private List<RectF> mRelativeCameraFaceMeteringRegions;

            private Builder() {
            }

            public Builder setCameraFrameCrop(float relativeCameraCropCenterX, float relativeCameraCropCenterY, float relativeCameraCropScale) {
                this.mRelativeCameraCropCenterX = relativeCameraCropCenterX;
                this.mRelativeCameraCropCenterY = relativeCameraCropCenterY;
                this.mRelativeCameraCropScale = relativeCameraCropScale;
                return this;
            }

            public Builder setCameraFrameExposureRegion(@Nullable RectF relativeCameraExposureRegion) {
                this.mRelativeCameraExposureRegion = relativeCameraExposureRegion == null ? null : new RectF(relativeCameraExposureRegion);
                return this;
            }

            public Builder setCameraFaceMeteringRegions(@Nullable List<RectF> relativeCameraFaceMeteringRegions) {
                this.mRelativeCameraFaceMeteringRegions = ModeSetting.deepCopy(relativeCameraFaceMeteringRegions);
                return this;
            }

            public ModeSetting build() {
                ModeSetting.checkState(!Float.isNaN(this.mRelativeCameraCropCenterX) && !Float.isNaN(this.mRelativeCameraCropCenterY) && !Float.isNaN(this.mRelativeCameraCropScale), "Camera crop must be supplied");
                Bundle bundle = ModeSetting.newBundle();
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_CENTER_X_KEY, this.mRelativeCameraCropCenterX);
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_CENTER_Y_KEY, this.mRelativeCameraCropCenterY);
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_SCALE_KEY, this.mRelativeCameraCropScale);
                bundle.putParcelable(Fixed.CAMERA_RELATIVE_EXPOSURE_REGION_KEY, (Parcelable)this.mRelativeCameraExposureRegion);
                bundle.putParcelableArrayList(Fixed.CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY, ModeSetting.toArrayList(this.mRelativeCameraFaceMeteringRegions));
                return new ModeSetting(Fixed.ID, bundle);
            }
        }
    }

    public static final class DefaultAuto {
        public static final String ID = "ModeSetting_DefaultAuto";

        private DefaultAuto() {
        }

        public static ModeSetting create() {
            return new ModeSetting(ID);
        }
    }
}

