/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.common.type;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class ModeSetting
implements Parcelable {
    private final int mId;
    private final Bundle mData;
    public static final Parcelable.Creator<ModeSetting> CREATOR = new Parcelable.Creator<ModeSetting>(){

        public ModeSetting createFromParcel(Parcel in) {
            return new ModeSetting(in);
        }

        public ModeSetting[] newArray(int size) {
            return new ModeSetting[size];
        }
    };

    private static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    private static void checkMode(ModeSetting mode, int expectedMode) {
        if (mode.getId() != expectedMode) {
            throw new IllegalArgumentException("Incompatible mode: " + mode);
        }
    }

    private static void checkKeyExists(ModeSetting mode, String key) {
        if (!mode.getData().containsKey(key)) {
            throw new IllegalArgumentException("Missing key: " + key);
        }
    }

    @Nullable
    private static List<RectF> deepCopy(@Nullable List<RectF> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RectF> copied = new ArrayList<RectF>(list.size());
        for (RectF rectF : list) {
            copied.add(new RectF(rectF));
        }
        return copied;
    }

    @Nullable
    private static <T> ArrayList<T> toArrayList(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        return list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<T>(list);
    }

    public ModeSetting() {
        this(0, ModeSetting.newBundle());
    }

    public ModeSetting(int id, Bundle data) {
        this.mId = id;
        this.mData = data;
    }

    public ModeSetting(int id) {
        this(id, ModeSetting.newBundle());
    }

    protected ModeSetting(Parcel in) {
        this(in.readInt(), in.readBundle(ModeSetting.class.getClassLoader()));
    }

    public int getId() {
        return this.mId;
    }

    public Bundle getData() {
        return this.mData;
    }

    protected static Bundle newBundle() {
        return new Bundle(ModeSetting.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeBundle(this.mData);
    }

    public int describeContents() {
        return 0;
    }

    public static final class Desk {
        public static final int ID = 8;

        private Desk() {
        }

        public static ModeSetting create() {
            return new ModeSetting(8);
        }
    }

    public static final class Meeting {
        public static final int ID = 7;

        private Meeting() {
        }

        public static ModeSetting create() {
            return new ModeSetting(7);
        }
    }

    public static final class Fixed {
        public static final int ID = 4;
        public static final String CAMERA_RELATIVE_CROP_CENTER_X_KEY = "camera.relative_crop_center_x";
        public static final String CAMERA_RELATIVE_CROP_CENTER_Y_KEY = "camera.relative_crop_center_y";
        public static final String CAMERA_RELATIVE_CROP_SCALE_KEY = "camera.relative_crop_scale";
        public static final String CAMERA_RELATIVE_EXPOSURE_REGION_KEY = "camera.relative_exposure_region";
        public static final String CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY = "camera.relative_face_metering_regions";

        private Fixed() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static float readRelativeCropCenterX(ModeSetting mode) {
            ModeSetting.checkMode(mode, 4);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_CENTER_X_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_CENTER_X_KEY);
        }

        public static float readRelativeCropCenterY(ModeSetting mode) {
            ModeSetting.checkMode(mode, 4);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_CENTER_Y_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_CENTER_Y_KEY);
        }

        public static float readRelativeCropScale(ModeSetting mode) {
            ModeSetting.checkMode(mode, 4);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_CROP_SCALE_KEY);
            return mode.getData().getFloat(CAMERA_RELATIVE_CROP_SCALE_KEY);
        }

        @Nullable
        public static RectF readRelativeExposureRegion(ModeSetting mode) {
            ModeSetting.checkMode(mode, 4);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_EXPOSURE_REGION_KEY);
            return (RectF)mode.getData().getParcelable(CAMERA_RELATIVE_EXPOSURE_REGION_KEY);
        }

        @Nullable
        public static List<RectF> readRelativeFaceMeteringRegions(ModeSetting mode) {
            ModeSetting.checkMode(mode, 4);
            ModeSetting.checkKeyExists(mode, CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY);
            return mode.getData().getParcelableArrayList(CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY);
        }

        public static final class Builder {
            private float mRelativeCameraCropCenterX = Float.NaN;
            private float mRelativeCameraCropCenterY = Float.NaN;
            private float mRelativeCameraCropScale = Float.NaN;
            @Nullable
            private RectF mRelativeCameraExposureRegion;
            @Nullable
            private List<RectF> mRelativeCameraFaceMeteringRegions;

            private Builder() {
            }

            public Builder setCameraFrameCrop(float relativeCameraCropCenterX, float relativeCameraCropCenterY, float relativeCameraCropScale) {
                this.mRelativeCameraCropCenterX = relativeCameraCropCenterX;
                this.mRelativeCameraCropCenterY = relativeCameraCropCenterY;
                this.mRelativeCameraCropScale = relativeCameraCropScale;
                return this;
            }

            public Builder setCameraFrameExposureRegion(@Nullable RectF relativeCameraExposureRegion) {
                this.mRelativeCameraExposureRegion = relativeCameraExposureRegion == null ? null : new RectF(relativeCameraExposureRegion);
                return this;
            }

            public Builder setCameraFaceMeteringRegions(@Nullable List<RectF> relativeCameraFaceMeteringRegions) {
                this.mRelativeCameraFaceMeteringRegions = ModeSetting.deepCopy(relativeCameraFaceMeteringRegions);
                return this;
            }

            public ModeSetting build() {
                ModeSetting.checkState(!Float.isNaN(this.mRelativeCameraCropCenterX) && !Float.isNaN(this.mRelativeCameraCropCenterY) && !Float.isNaN(this.mRelativeCameraCropScale), "Camera crop must be supplied");
                Bundle bundle = ModeSetting.newBundle();
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_CENTER_X_KEY, this.mRelativeCameraCropCenterX);
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_CENTER_Y_KEY, this.mRelativeCameraCropCenterY);
                bundle.putFloat(Fixed.CAMERA_RELATIVE_CROP_SCALE_KEY, this.mRelativeCameraCropScale);
                bundle.putParcelable(Fixed.CAMERA_RELATIVE_EXPOSURE_REGION_KEY, (Parcelable)this.mRelativeCameraExposureRegion);
                bundle.putParcelableArrayList(Fixed.CAMERA_RELATIVE_FACE_METERING_REGIONS_KEY, ModeSetting.toArrayList(this.mRelativeCameraFaceMeteringRegions));
                return new ModeSetting(4, bundle);
            }
        }
    }

    public static final class Storytime {
        public static final int ID = 3;

        private Storytime() {
        }

        public static ModeSetting create() {
            return new ModeSetting(3);
        }
    }

    public static final class Spotlight {
        public static final int ID = 2;
        public static final String PERSON_ID_KEY = "person_id";

        private Spotlight() {
        }

        public static ModeSetting create(int personId) {
            Bundle bundle = ModeSetting.newBundle();
            bundle.putInt(PERSON_ID_KEY, personId);
            return new ModeSetting(2, bundle);
        }

        public static int readPersonId(ModeSetting mode) {
            ModeSetting.checkMode(mode, 2);
            ModeSetting.checkKeyExists(mode, PERSON_ID_KEY);
            return mode.getData().getInt(PERSON_ID_KEY);
        }
    }

    public static final class FullWide {
        public static final int ID = 1;

        private FullWide() {
        }

        public static ModeSetting create() {
            return new ModeSetting(1);
        }
    }

    public static final class DefaultAuto {
        public static final int ID = 0;

        private DefaultAuto() {
        }

        public static ModeSetting create() {
            return new ModeSetting(0);
        }
    }
}

