/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.control;

import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.portal.smartcamera.base.type.SessionPropertiesBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class SessionProperty<T> {
    private static final Set<String> SUPPORTED_SESSION_PROPERTY_NAMES = Collections.emptySet();
    private final String mName;
    private final Class<? extends T> mType;

    public static boolean isSupportedProperty(String propertyName) {
        return SUPPORTED_SESSION_PROPERTY_NAMES.contains(propertyName);
    }

    public static boolean isSupportedBundle(SessionPropertiesBundle sessionPropertiesBundle) {
        for (String propertyName : sessionPropertiesBundle.getData().keySet()) {
            if (SessionProperty.isSupportedProperty(propertyName)) continue;
            return false;
        }
        return true;
    }

    public SessionProperty(String name, Class<? extends T> type) {
        this.mName = name;
        this.mType = type;
    }

    public String getName() {
        return this.mName;
    }

    public Class<? extends T> getType() {
        return this.mType;
    }

    public static void copy(SessionProperty<?> sessionProperty, SessionPropertiesBundle from, SessionPropertiesBundle to) {
        SessionProperty.copy(sessionProperty, from.getData(), to.getData());
    }

    protected static void copy(SessionProperty<?> sessionProperty, Bundle from, Bundle to) {
        if (!from.containsKey(sessionProperty.getName())) {
            throw new IllegalStateException("source does not contain SessionProperty: " + sessionProperty.getName());
        }
        Class<?> type = sessionProperty.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            to.putBoolean(sessionProperty.getName(), from.getBoolean(sessionProperty.getName()));
            return;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            to.putByte(sessionProperty.getName(), from.getByte(sessionProperty.getName()));
            return;
        }
        if (type == Short.TYPE || type == Short.class) {
            to.putShort(sessionProperty.getName(), from.getShort(sessionProperty.getName()));
            return;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            to.putInt(sessionProperty.getName(), from.getInt(sessionProperty.getName()));
            return;
        }
        if (type == Long.TYPE || type == Long.class) {
            to.putLong(sessionProperty.getName(), from.getLong(sessionProperty.getName()));
            return;
        }
        if (type == Float.TYPE || type == Float.class) {
            to.putFloat(sessionProperty.getName(), from.getFloat(sessionProperty.getName()));
            return;
        }
        if (type == Double.TYPE || type == Double.class) {
            to.putDouble(sessionProperty.getName(), from.getDouble(sessionProperty.getName()));
            return;
        }
        if (Parcelable.class.isAssignableFrom(type)) {
            to.putParcelable(sessionProperty.getName(), from.getParcelable(sessionProperty.getName()));
            return;
        }
        if (type == boolean[].class || type == Boolean[].class) {
            to.putBooleanArray(sessionProperty.getName(), from.getBooleanArray(sessionProperty.getName()));
            return;
        }
        if (type == byte[].class || type == Byte[].class) {
            to.putByteArray(sessionProperty.getName(), from.getByteArray(sessionProperty.getName()));
            return;
        }
        if (type == short[].class || type == Short[].class) {
            to.putShortArray(sessionProperty.getName(), from.getShortArray(sessionProperty.getName()));
            return;
        }
        if (type == int[].class || type == Integer[].class) {
            to.putIntArray(sessionProperty.getName(), from.getIntArray(sessionProperty.getName()));
            return;
        }
        if (type == long[].class || type == Long[].class) {
            to.putLongArray(sessionProperty.getName(), from.getLongArray(sessionProperty.getName()));
            return;
        }
        if (type == float[].class || type == Float[].class) {
            to.putFloatArray(sessionProperty.getName(), from.getFloatArray(sessionProperty.getName()));
            return;
        }
        if (type == double[].class || type == Double[].class) {
            to.putDoubleArray(sessionProperty.getName(), from.getDoubleArray(sessionProperty.getName()));
            return;
        }
        if (type.isArray() && Parcelable.class.isAssignableFrom(type.getComponentType())) {
            to.putParcelableArray(sessionProperty.getName(), from.getParcelableArray(sessionProperty.getName()));
            return;
        }
        if (type == ArrayList.class) {
            to.putParcelableArrayList(sessionProperty.getName(), from.getParcelableArrayList(sessionProperty.getName()));
            return;
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    protected static <T> ArrayList<T> toArrayList(List<T> list) {
        if (list instanceof ArrayList) {
            return (ArrayList)list;
        }
        return new ArrayList<T>(list);
    }

    protected static <T> Class<T> castClass(Class<?> clazz) {
        return clazz;
    }

    protected static <T> List<T> castList(List<?> clazz) {
        return clazz;
    }
}

