/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.external.control;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.facebook.portal.smartcamera.base.type.ModeSetting;
import com.facebook.portal.smartcamera.base.type.SessionPropertiesBundle;

public interface IControlSession
extends IInterface {
    public static final String DESCRIPTOR = "com.facebook.portal.smartcamera.external.control.IControlSession";

    public void close() throws RemoteException;

    public void setMode(ModeSetting var1) throws RemoteException;

    public boolean isSessionPropertySupported(String var1) throws RemoteException;

    public void setSessionProperties(SessionPropertiesBundle var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IControlSession {
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_setMode = 3;
        static final int TRANSACTION_isSessionPropertySupported = 4;
        static final int TRANSACTION_setSessionProperties = 5;

        public Stub() {
            this.attachInterface(this, IControlSession.DESCRIPTOR);
        }

        public static IControlSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IControlSession.DESCRIPTOR);
            if (iin != null && iin instanceof IControlSession) {
                return (IControlSession)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IControlSession.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ModeSetting _arg0 = 0 != data.readInt() ? (ModeSetting)ModeSetting.CREATOR.createFromParcel(data) : null;
                    this.setMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isSessionPropertySupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    SessionPropertiesBundle _arg0 = 0 != data.readInt() ? (SessionPropertiesBundle)SessionPropertiesBundle.CREATOR.createFromParcel(data) : null;
                    this.setSessionProperties(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IControlSession impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IControlSession getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IControlSession {
            private IBinder mRemote;
            public static IControlSession sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IControlSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IControlSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().close();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(ModeSetting mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IControlSession.DESCRIPTOR);
                    if (mode != null) {
                        _data.writeInt(1);
                        mode.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMode(mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSessionPropertySupported(String propertyKey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IControlSession.DESCRIPTOR);
                    _data.writeString(propertyKey);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSessionPropertySupported(propertyKey);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionProperties(SessionPropertiesBundle properties) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IControlSession.DESCRIPTOR);
                    if (properties != null) {
                        _data.writeInt(1);
                        properties.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionProperties(properties);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IControlSession {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void setMode(ModeSetting mode) throws RemoteException {
        }

        @Override
        public boolean isSessionPropertySupported(String propertyKey) throws RemoteException {
            return false;
        }

        @Override
        public void setSessionProperties(SessionPropertiesBundle properties) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

