/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.external.metadata;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.facebook.portal.smartcamera.base.type.ModeSetting;
import com.facebook.portal.smartcamera.external.metadata.IModeListener;
import com.facebook.portal.smartcamera.metadata.IStreamingMetadataReceiver;
import com.facebook.portal.smartcamera.metadata.MetadataBundle;
import java.util.ArrayList;
import java.util.List;

public interface ISmartCameraMetadataConnection
extends IInterface {
    public static final String DESCRIPTOR = "com.facebook.portal.smartcamera.external.metadata.ISmartCameraMetadataConnection";

    public void close() throws RemoteException;

    public ModeSetting getMode() throws RemoteException;

    public ModeSetting subscribeModeChanges(IModeListener var1) throws RemoteException;

    public void unsubscribeModeChanges(IModeListener var1) throws RemoteException;

    public MetadataBundle getFrameMetadata(List<String> var1) throws RemoteException;

    public MetadataBundle subscribeFrameMetadata(IStreamingMetadataReceiver var1, List<String> var2, float var3) throws RemoteException;

    public void unsubscribeFrameMetadata(IStreamingMetadataReceiver var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISmartCameraMetadataConnection {
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_getMode = 2;
        static final int TRANSACTION_subscribeModeChanges = 3;
        static final int TRANSACTION_unsubscribeModeChanges = 4;
        static final int TRANSACTION_getFrameMetadata = 5;
        static final int TRANSACTION_subscribeFrameMetadata = 6;
        static final int TRANSACTION_unsubscribeFrameMetadata = 7;

        public Stub() {
            this.attachInterface(this, ISmartCameraMetadataConnection.DESCRIPTOR);
        }

        public static ISmartCameraMetadataConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISmartCameraMetadataConnection.DESCRIPTOR);
            if (iin != null && iin instanceof ISmartCameraMetadataConnection) {
                return (ISmartCameraMetadataConnection)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISmartCameraMetadataConnection.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.close();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ModeSetting _result = this.getMode();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IModeListener _arg0 = IModeListener.Stub.asInterface(data.readStrongBinder());
                    ModeSetting _result = this.subscribeModeChanges(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IModeListener _arg0 = IModeListener.Stub.asInterface(data.readStrongBinder());
                    this.unsubscribeModeChanges(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ArrayList _arg0 = data.createStringArrayList();
                    MetadataBundle _result = this.getFrameMetadata(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IStreamingMetadataReceiver _arg0 = IStreamingMetadataReceiver.Stub.asInterface(data.readStrongBinder());
                    ArrayList _arg1 = data.createStringArrayList();
                    float _arg2 = data.readFloat();
                    MetadataBundle _result = this.subscribeFrameMetadata(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IStreamingMetadataReceiver _arg0 = IStreamingMetadataReceiver.Stub.asInterface(data.readStrongBinder());
                    this.unsubscribeFrameMetadata(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISmartCameraMetadataConnection impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISmartCameraMetadataConnection getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISmartCameraMetadataConnection {
            private IBinder mRemote;
            public static ISmartCameraMetadataConnection sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISmartCameraMetadataConnection.DESCRIPTOR;
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().close();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ModeSetting getMode() throws RemoteException {
                ModeSetting _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ModeSetting modeSetting = Stub.getDefaultImpl().getMode();
                        return modeSetting;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ModeSetting)ModeSetting.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ModeSetting subscribeModeChanges(IModeListener listener) throws RemoteException {
                ModeSetting _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ModeSetting modeSetting = Stub.getDefaultImpl().subscribeModeChanges(listener);
                        return modeSetting;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ModeSetting)ModeSetting.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsubscribeModeChanges(IModeListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unsubscribeModeChanges(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MetadataBundle getFrameMetadata(List<String> topicNames) throws RemoteException {
                MetadataBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    _data.writeStringList(topicNames);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        MetadataBundle metadataBundle = Stub.getDefaultImpl().getFrameMetadata(topicNames);
                        return metadataBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (MetadataBundle)MetadataBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MetadataBundle subscribeFrameMetadata(IStreamingMetadataReceiver receiver, List<String> topicNames, float maxUpdatesPerSec) throws RemoteException {
                MetadataBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    _data.writeStringList(topicNames);
                    _data.writeFloat(maxUpdatesPerSec);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        MetadataBundle metadataBundle = Stub.getDefaultImpl().subscribeFrameMetadata(receiver, topicNames, maxUpdatesPerSec);
                        return metadataBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (MetadataBundle)MetadataBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsubscribeFrameMetadata(IStreamingMetadataReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartCameraMetadataConnection.DESCRIPTOR);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unsubscribeFrameMetadata(receiver);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISmartCameraMetadataConnection {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public ModeSetting getMode() throws RemoteException {
            return null;
        }

        @Override
        public ModeSetting subscribeModeChanges(IModeListener listener) throws RemoteException {
            return null;
        }

        @Override
        public void unsubscribeModeChanges(IModeListener listener) throws RemoteException {
        }

        @Override
        public MetadataBundle getFrameMetadata(List<String> topicNames) throws RemoteException {
            return null;
        }

        @Override
        public MetadataBundle subscribeFrameMetadata(IStreamingMetadataReceiver receiver, List<String> topicNames, float maxUpdatesPerSec) throws RemoteException {
            return null;
        }

        @Override
        public void unsubscribeFrameMetadata(IStreamingMetadataReceiver receiver) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

