/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.internal.control;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.facebook.portal.smartcamera.base.type.ModeSetting;
import com.facebook.portal.smartcamera.base.type.SessionPropertiesBundle;

public interface IInternalControlSession
extends IInterface {
    public static final String DESCRIPTOR = "com.facebook.portal.smartcamera.internal.control.IInternalControlSession";

    public void close() throws RemoteException;

    public void setOrientation(int var1) throws RemoteException;

    public void setMode(ModeSetting var1) throws RemoteException;

    public void setLoggingTag(String var1) throws RemoteException;

    public boolean isSessionPropertySupported(String var1) throws RemoteException;

    public void setSessionProperties(SessionPropertiesBundle var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInternalControlSession {
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_setOrientation = 2;
        static final int TRANSACTION_setMode = 3;
        static final int TRANSACTION_setLoggingTag = 4;
        static final int TRANSACTION_isSessionPropertySupported = 5;
        static final int TRANSACTION_setSessionProperties = 6;

        public Stub() {
            this.attachInterface(this, IInternalControlSession.DESCRIPTOR);
        }

        public static IInternalControlSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInternalControlSession.DESCRIPTOR);
            if (iin != null && iin instanceof IInternalControlSession) {
                return (IInternalControlSession)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInternalControlSession.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.close();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setOrientation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ModeSetting _arg0 = 0 != data.readInt() ? (ModeSetting)ModeSetting.CREATOR.createFromParcel(data) : null;
                    this.setMode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setLoggingTag(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isSessionPropertySupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    SessionPropertiesBundle _arg0 = 0 != data.readInt() ? (SessionPropertiesBundle)SessionPropertiesBundle.CREATOR.createFromParcel(data) : null;
                    this.setSessionProperties(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInternalControlSession impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInternalControlSession getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInternalControlSession {
            private IBinder mRemote;
            public static IInternalControlSession sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInternalControlSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().close();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOrientation(int orientationRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    _data.writeInt(orientationRequest);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOrientation(orientationRequest);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(ModeSetting mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    if (mode != null) {
                        _data.writeInt(1);
                        mode.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMode(mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLoggingTag(String value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    _data.writeString(value);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLoggingTag(value);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSessionPropertySupported(String propertyKey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    _data.writeString(propertyKey);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSessionPropertySupported(propertyKey);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionProperties(SessionPropertiesBundle properties) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IInternalControlSession.DESCRIPTOR);
                    if (properties != null) {
                        _data.writeInt(1);
                        properties.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionProperties(properties);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInternalControlSession {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void setOrientation(int orientationRequest) throws RemoteException {
        }

        @Override
        public void setMode(ModeSetting mode) throws RemoteException {
        }

        @Override
        public void setLoggingTag(String value) throws RemoteException {
        }

        @Override
        public boolean isSessionPropertySupported(String propertyKey) throws RemoteException {
            return false;
        }

        @Override
        public void setSessionProperties(SessionPropertiesBundle properties) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

