/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.portal.smartcamera.metadata;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.portal.smartcamera.metadata.MetadataBundle;
import java.util.ArrayList;
import java.util.List;

public abstract class Topic<T> {
    private final String mName;
    private final Class<? extends T> mType;

    public Topic(String name, Class<? extends T> type) {
        this.mName = name;
        this.mType = type;
    }

    public String getName() {
        return this.mName;
    }

    public Class<? extends T> getType() {
        return this.mType;
    }

    public static void copy(Topic<?> topic, MetadataBundle from, MetadataBundle to) {
        Topic.copy(topic, from.getData(), to.getData());
    }

    protected static void copy(Topic<?> topic, Bundle from, Bundle to) {
        if (!from.containsKey(topic.getName())) {
            throw new IllegalStateException("source does not contain topic: " + topic.getName());
        }
        Class<?> type = topic.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            to.putBoolean(topic.getName(), from.getBoolean(topic.getName()));
            return;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            to.putByte(topic.getName(), from.getByte(topic.getName()));
            return;
        }
        if (type == Short.TYPE || type == Short.class) {
            to.putShort(topic.getName(), from.getShort(topic.getName()));
            return;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            to.putInt(topic.getName(), from.getInt(topic.getName()));
            return;
        }
        if (type == Long.TYPE || type == Long.class) {
            to.putLong(topic.getName(), from.getLong(topic.getName()));
            return;
        }
        if (type == Float.TYPE || type == Float.class) {
            to.putFloat(topic.getName(), from.getFloat(topic.getName()));
            return;
        }
        if (type == Double.TYPE || type == Double.class) {
            to.putDouble(topic.getName(), from.getDouble(topic.getName()));
            return;
        }
        if (Parcelable.class.isAssignableFrom(type)) {
            to.putParcelable(topic.getName(), from.getParcelable(topic.getName()));
            return;
        }
        if (type == boolean[].class || type == Boolean[].class) {
            to.putBooleanArray(topic.getName(), from.getBooleanArray(topic.getName()));
            return;
        }
        if (type == byte[].class || type == Byte[].class) {
            to.putByteArray(topic.getName(), from.getByteArray(topic.getName()));
            return;
        }
        if (type == short[].class || type == Short[].class) {
            to.putShortArray(topic.getName(), from.getShortArray(topic.getName()));
            return;
        }
        if (type == int[].class || type == Integer[].class) {
            to.putIntArray(topic.getName(), from.getIntArray(topic.getName()));
            return;
        }
        if (type == long[].class || type == Long[].class) {
            to.putLongArray(topic.getName(), from.getLongArray(topic.getName()));
            return;
        }
        if (type == float[].class || type == Float[].class) {
            to.putFloatArray(topic.getName(), from.getFloatArray(topic.getName()));
            return;
        }
        if (type == double[].class || type == Double[].class) {
            to.putDoubleArray(topic.getName(), from.getDoubleArray(topic.getName()));
            return;
        }
        if (type.isArray() && Parcelable.class.isAssignableFrom(type.getComponentType())) {
            to.putParcelableArray(topic.getName(), from.getParcelableArray(topic.getName()));
            return;
        }
        if (type == ArrayList.class) {
            to.putParcelableArrayList(topic.getName(), from.getParcelableArrayList(topic.getName()));
            return;
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    protected static <T> ArrayList<T> toArrayList(List<T> list) {
        if (list instanceof ArrayList) {
            return (ArrayList)list;
        }
        return new ArrayList<T>(list);
    }

    protected static <T> Class<T> castClass(Class<?> clazz) {
        return clazz;
    }

    protected static <T> List<T> castList(List<?> clazz) {
        return clazz;
    }

    public static abstract class Frame<T>
    extends Topic<T> {
        public Frame(String name, Class<? extends T> type) {
            super(name, type);
        }

        public static final class FullFovAspectRatio
        extends Frame<Float> {
            public static final FullFovAspectRatio KEY = new FullFovAspectRatio();

            private FullFovAspectRatio() {
                super("full_fov_aspect_ratio", Float.TYPE);
            }

            public static void write(MetadataBundle bundle, float aspectRatio) {
                bundle.getData().putFloat(KEY.getName(), aspectRatio);
            }

            public static float read(MetadataBundle bundle) {
                return bundle.getData().getFloat(KEY.getName());
            }
        }

        public static final class Crop
        extends Frame<RectF> {
            public static final Crop KEY = new Crop();

            private Crop() {
                super("crop", RectF.class);
            }

            public static void write(MetadataBundle bundle, RectF crop) {
                bundle.getData().putParcelable(KEY.getName(), (Parcelable)crop);
            }

            public static RectF read(MetadataBundle bundle) {
                return (RectF)bundle.getData().getParcelable(KEY.getName());
            }
        }
    }

    public static abstract class World<T>
    extends Topic<T> {
        public World(String name, Class<? extends T> type) {
            super(name, type);
        }
    }
}

