// Copyright 2004-present Facebook. All Rights Reserved.

package com.facebook.portal.smartcamera.internal.control;

import com.facebook.portal.smartcamera.base.type.ModeSetting;
import com.facebook.portal.smartcamera.common.type.Orientation;
import com.facebook.portal.smartcamera.base.type.SessionPropertiesBundle;

/**
 * A session that enables exclusive control over the Smart Camera.
 */
interface IInternalControlSession {

  /**
   * Close the control session, making it available for other applications, and freeing the
   * underlying resources.
   */
  void close() = 0;

  /**
   * Apply the {@link OrientationRequest} to the current video output.
   *
   * @throws IllegalStateException if this control session is no longer active.
   */
  void setOrientation(int orientationRequest) = 1;

  /**
   * Set the current Smart Camera mode.
   *
   * @throws IllegalStateException if this control session is no longer active.
   */
  void setMode(in ModeSetting mode) = 2;

  /**
   * Set a tag for logging
   *
   * @throws IllegalStateException if this control session is no longer active.
   */
  void setLoggingTag(in String value) = 3;

  /**
   * Checks if a session property is supported.
   */
  boolean isSessionPropertySupported(in String propertyKey) = 4;

  /**
   * Sets all of the provided session properties.
   * If a session property is not supported the API is a no-op.
   */
  void setSessionProperties(in SessionPropertiesBundle properties) = 5;
}
