/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.$internal.com.google.common.base.Predicate;
import com.datastax.driver.$internal.com.google.common.collect.Iterables;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableOptionsMetadata;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractTableMetadata {
    static final Comparator<ColumnMetadata> columnMetadataComparator = new Comparator<ColumnMetadata>(){

        @Override
        public int compare(ColumnMetadata c1, ColumnMetadata c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    static final Predicate<ClusteringOrder> isAscending = new Predicate<ClusteringOrder>(){

        @Override
        public boolean apply(ClusteringOrder o) {
            return o == ClusteringOrder.ASC;
        }
    };
    protected final KeyspaceMetadata keyspace;
    protected final String name;
    protected final UUID id;
    protected final List<ColumnMetadata> partitionKey;
    protected final List<ColumnMetadata> clusteringColumns;
    protected final Map<String, ColumnMetadata> columns;
    protected final TableOptionsMetadata options;
    protected final List<ClusteringOrder> clusteringOrder;
    protected final VersionNumber cassandraVersion;

    protected AbstractTableMetadata(KeyspaceMetadata keyspace, String name, UUID id, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, Map<String, ColumnMetadata> columns, TableOptionsMetadata options, List<ClusteringOrder> clusteringOrder, VersionNumber cassandraVersion) {
        this.keyspace = keyspace;
        this.name = name;
        this.id = id;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
        this.clusteringOrder = clusteringOrder;
        this.cassandraVersion = cassandraVersion;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(Metadata.handleId(name));
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public List<ColumnMetadata> getPrimaryKey() {
        ArrayList<ColumnMetadata> pk = new ArrayList<ColumnMetadata>(this.partitionKey.size() + this.clusteringColumns.size());
        pk.addAll(this.partitionKey);
        pk.addAll(this.clusteringColumns);
        return pk;
    }

    public List<ColumnMetadata> getPartitionKey() {
        return Collections.unmodifiableList(this.partitionKey);
    }

    public List<ColumnMetadata> getClusteringColumns() {
        return Collections.unmodifiableList(this.clusteringColumns);
    }

    public List<ClusteringOrder> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public TableOptionsMetadata getOptions() {
        return this.options;
    }

    void add(ColumnMetadata column) {
        this.columns.put(column.getName(), column);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery(true));
        return sb.toString();
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    protected abstract String asCQLQuery(boolean var1);

    protected StringBuilder appendOptions(StringBuilder sb, boolean formatted) {
        sb.append(" WITH ");
        if (this.options.isCompactStorage()) {
            this.and(sb.append("COMPACT STORAGE"), formatted);
        }
        if (!Iterables.all(this.clusteringOrder, isAscending)) {
            this.and(this.appendClusteringOrder(sb), formatted);
        }
        sb.append("read_repair_chance = ").append(this.options.getReadRepairChance());
        this.and(sb, formatted).append("dclocal_read_repair_chance = ").append(this.options.getLocalReadRepairChance());
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() == 0) {
            this.and(sb, formatted).append("replicate_on_write = ").append(this.options.getReplicateOnWrite());
        }
        this.and(sb, formatted).append("gc_grace_seconds = ").append(this.options.getGcGraceInSeconds());
        this.and(sb, formatted).append("bloom_filter_fp_chance = ").append(this.options.getBloomFilterFalsePositiveChance());
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() < 1) {
            this.and(sb, formatted).append("caching = '").append(this.options.getCaching().get("keys")).append('\'');
        } else {
            this.and(sb, formatted).append("caching = ").append(AbstractTableMetadata.formatOptionMap(this.options.getCaching()));
        }
        if (this.options.getComment() != null) {
            this.and(sb, formatted).append("comment = '").append(this.options.getComment().replace("'", "''")).append('\'');
        }
        this.and(sb, formatted).append("compaction = ").append(AbstractTableMetadata.formatOptionMap(this.options.getCompaction()));
        this.and(sb, formatted).append("compression = ").append(AbstractTableMetadata.formatOptionMap(this.options.getCompression()));
        if (this.cassandraVersion.getMajor() >= 2) {
            this.and(sb, formatted).append("default_time_to_live = ").append(this.options.getDefaultTimeToLive());
            this.and(sb, formatted).append("speculative_retry = '").append(this.options.getSpeculativeRetry()).append('\'');
            if (this.options.getIndexInterval() != null) {
                this.and(sb, formatted).append("index_interval = ").append(this.options.getIndexInterval());
            }
        }
        if (this.cassandraVersion.getMajor() > 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() >= 1) {
            this.and(sb, formatted).append("min_index_interval = ").append(this.options.getMinIndexInterval());
            this.and(sb, formatted).append("max_index_interval = ").append(this.options.getMaxIndexInterval());
        }
        if (this.cassandraVersion.getMajor() > 2) {
            this.and(sb, formatted).append("crc_check_chance = ").append(this.options.getCrcCheckChance());
        }
        sb.append(';');
        return sb;
    }

    public String toString() {
        return this.asCQLQuery();
    }

    private StringBuilder appendClusteringOrder(StringBuilder sb) {
        sb.append("CLUSTERING ORDER BY (");
        for (int i = 0; i < this.clusteringColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clusteringColumns.get(i).getName()).append(' ').append((Object)this.clusteringOrder.get(i));
        }
        return sb.append(')');
    }

    private static String formatOptionMap(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\'').append(entry.getKey()).append('\'');
            sb.append(" : ");
            try {
                sb.append(Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException e) {
                sb.append('\'').append(entry.getValue()).append('\'');
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    private StringBuilder and(StringBuilder sb, boolean formatted) {
        return AbstractTableMetadata.newLine(sb, formatted).append(AbstractTableMetadata.spaces(2, formatted)).append(" AND ");
    }

    static String spaces(int n, boolean formatted) {
        if (!formatted) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static StringBuilder newLine(StringBuilder sb, boolean formatted) {
        if (formatted) {
            sb.append('\n');
        }
        return sb;
    }

    static StringBuilder spaceOrNewLine(StringBuilder sb, boolean formatted) {
        sb.append(formatted ? (char)'\n' : ' ');
        return sb;
    }
}

