/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.$internal.com.google.common.collect.ArrayListMultimap;
import org.apache.cassandra.$internal.com.google.common.collect.Multimap;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingCache {
    private static final Logger logger = LoggerFactory.getLogger(RingCache.class);
    private final IPartitioner partitioner;
    private final Configuration conf;
    private Multimap<Range<Token>, InetAddress> rangeMap;

    public RingCache(Configuration conf) {
        this.conf = conf;
        this.partitioner = ConfigHelper.getOutputPartitioner(conf);
        this.refreshEndpointMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshEndpointMap() {
        try {
            Cassandra.Client client = ConfigHelper.getClientFromOutputAddressList(this.conf);
            String keyspace = ConfigHelper.getOutputKeyspace(this.conf);
            List ring = ConfigHelper.getOutputLocalDCOnly(this.conf) ? client.describe_local_ring(keyspace) : client.describe_ring(keyspace);
            this.rangeMap = ArrayListMultimap.create();
            for (TokenRange range : ring) {
                Token left = this.partitioner.getTokenFactory().fromString(range.start_token);
                Token right = this.partitioner.getTokenFactory().fromString(range.end_token);
                Range<Token> r = new Range<Token>(left, right, this.partitioner);
                for (String host : range.endpoints) {
                    try {
                        this.rangeMap.put(r, InetAddress.getByName(host));
                    }
                    catch (UnknownHostException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                continue;
                return;
            }
        }
        catch (IOException | InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (TException e) {
            logger.debug("Error contacting seed list {} {}", (Object)ConfigHelper.getOutputInitialAddress(this.conf), (Object)e.getMessage());
        }
    }

    public List<InetAddress> getEndpoint(Range<Token> range) {
        return (List)this.rangeMap.get(range);
    }

    public List<InetAddress> getEndpoint(ByteBuffer key) {
        return this.getEndpoint(this.getRange(key));
    }

    public Range<Token> getRange(ByteBuffer key) {
        Token t = this.partitioner.getToken(key);
        for (Range<Token> range : this.rangeMap.keySet()) {
            if (!range.contains(t)) continue;
            return range;
        }
        throw new RuntimeException("Invalid token information returned by describe_ring: " + this.rangeMap);
    }
}

