/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.$internal.com.google.common.base.Function;
import org.apache.cassandra.$internal.com.google.common.collect.Iterables;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatement
implements CQLStatement {
    private final int boundTerms;
    public final Type type;
    private final List<ModificationStatement> statements;
    private final Attributes attrs;
    private final boolean hasConditions;
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);
    private static final String unloggedBatchWarning = "Unlogged batch covering {} partitions detected against table{} {}. You should use a logged batch for atomicity, or asynchronous writes for performance.";

    public BatchStatement(int boundTerms, Type type, List<ModificationStatement> statements, Attributes attrs) {
        boolean hasConditions = false;
        for (ModificationStatement statement : statements) {
            hasConditions |= statement.hasConditions();
        }
        this.boundTerms = boundTerms;
        this.type = type;
        this.statements = statements;
        this.attrs = attrs;
        this.hasConditions = hasConditions;
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        for (ModificationStatement statement : this.statements) {
            statement.checkAccess(state);
        }
    }

    public void validate() throws InvalidRequestException {
        if (this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        boolean timestampSet = this.attrs.isTimestampSet();
        if (timestampSet) {
            if (this.hasConditions) {
                throw new InvalidRequestException("Cannot provide custom timestamp for conditional BATCH");
            }
            if (this.type == Type.COUNTER) {
                throw new InvalidRequestException("Cannot provide custom timestamp for counter BATCH");
            }
        }
        boolean hasCounters = false;
        boolean hasNonCounters = false;
        for (ModificationStatement statement : this.statements) {
            if (timestampSet && statement.isCounter()) {
                throw new InvalidRequestException("Cannot provide custom timestamp for a BATCH containing counters");
            }
            if (timestampSet && statement.isTimestampSet()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (this.type == Type.COUNTER && !statement.isCounter()) {
                throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
            }
            if (this.type == Type.LOGGED && statement.isCounter()) {
                throw new InvalidRequestException("Cannot include a counter statement in a logged batch");
            }
            if (statement.isCounter()) {
                hasCounters = true;
                continue;
            }
            hasNonCounters = true;
        }
        if (hasCounters && hasNonCounters) {
            throw new InvalidRequestException("Counter and non-counter mutations cannot exist in the same batch");
        }
        if (this.hasConditions) {
            String ksName = null;
            String cfName = null;
            for (ModificationStatement stmt : this.statements) {
                if (!(ksName == null || stmt.keyspace().equals(ksName) && stmt.columnFamily().equals(cfName))) {
                    throw new InvalidRequestException("Batch with conditions cannot span multiple tables");
                }
                ksName = stmt.keyspace();
                cfName = stmt.columnFamily();
            }
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.validate(state);
        }
    }

    public List<ModificationStatement> getStatements() {
        return this.statements;
    }

    private Collection<? extends IMutation> getMutations(BatchQueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        HashMap<String, Map<ByteBuffer, IMutation>> mutations = new HashMap<String, Map<ByteBuffer, IMutation>>();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            this.addStatementMutations(statement, statementOptions, local, timestamp, mutations);
        }
        return this.unzipMutations(mutations);
    }

    private Collection<? extends IMutation> unzipMutations(Map<String, Map<ByteBuffer, IMutation>> mutations) {
        if (mutations.size() == 1) {
            return mutations.values().iterator().next().values();
        }
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutation> ksMap : mutations.values()) {
            ms.addAll(ksMap.values());
        }
        return ms;
    }

    private void addStatementMutations(ModificationStatement statement, QueryOptions options, boolean local, long now, Map<String, Map<ByteBuffer, IMutation>> mutations) throws RequestExecutionException, RequestValidationException {
        String ksName = statement.keyspace();
        Map<ByteBuffer, IMutation> ksMap = mutations.get(ksName);
        if (ksMap == null) {
            ksMap = new HashMap<ByteBuffer, IMutation>();
            mutations.put(ksName, ksMap);
        }
        List<ByteBuffer> keys = statement.buildPartitionKeyNames(options);
        Composite clusteringPrefix = statement.createClusteringPrefix(options);
        UpdateParameters params = statement.makeUpdateParameters(keys, clusteringPrefix, options, local, now);
        for (ByteBuffer key : keys) {
            Mutation mut;
            IMutation mutation = ksMap.get(key);
            if (mutation == null) {
                mut = new Mutation(ksName, key);
                mutation = statement.cfm.isCounter() ? new CounterMutation(mut, options.getConsistency()) : mut;
                ksMap.put(key, mutation);
            } else {
                mut = statement.cfm.isCounter() ? ((CounterMutation)mutation).getMutation() : (Mutation)mutation;
            }
            statement.addUpdateForKey(mut.addOrGet(statement.cfm), key, clusteringPrefix, params);
        }
    }

    public static void verifyBatchSize(Iterable<ColumnFamily> cfs) {
        long size = 0L;
        long warnThreshold = DatabaseDescriptor.getBatchSizeWarnThreshold();
        for (ColumnFamily cf : cfs) {
            size += cf.dataSize();
        }
        if (size > warnThreshold) {
            HashSet<String> ksCfPairs = new HashSet<String>();
            for (ColumnFamily cf : cfs) {
                ksCfPairs.add(String.format("%s.%s", cf.metadata().ksName, cf.metadata().cfName));
            }
            String format = "Batch of prepared statements for {} is of size {}, exceeding specified threshold of {} by {}.";
            logger.warn(format, new Object[]{ksCfPairs, size, warnThreshold, size - warnThreshold});
        }
    }

    private void verifyBatchType(Collection<? extends IMutation> mutations) {
        if (this.type != Type.LOGGED && mutations.size() > 1) {
            HashSet<String> ksCfPairs = new HashSet<String>();
            HashSet<ByteBuffer> keySet = new HashSet<ByteBuffer>();
            for (IMutation iMutation : mutations) {
                keySet.add(iMutation.key());
                for (ColumnFamily cf : iMutation.getColumnFamilies()) {
                    ksCfPairs.add(String.format("%s.%s", cf.metadata().ksName, cf.metadata().cfName));
                }
            }
            if (keySet.size() > DatabaseDescriptor.getUnloggedBatchAcrossPartitionsWarnThreshold()) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, unloggedBatchWarning, keySet.size(), ksCfPairs.size() == 1 ? "" : "s", ksCfPairs);
            }
        }
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, BatchQueryOptions.withoutPerStatementVariables(options));
    }

    public ResultMessage execute(QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(queryState, options, false, options.getTimestamp(queryState));
    }

    private ResultMessage execute(QueryState queryState, BatchQueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (options.getSerialConsistency() == null) {
            throw new InvalidRequestException("Invalid empty serial consistency level");
        }
        if (this.hasConditions) {
            return this.executeWithConditions(options, queryState);
        }
        this.executeWithoutConditions(this.getMutations(options, local, now), options.getConsistency());
        return new ResultMessage.Void();
    }

    private void executeWithoutConditions(Collection<? extends IMutation> mutations, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        Iterable<ColumnFamily> cfs = Iterables.concat(Iterables.transform(mutations, new Function<IMutation, Collection<ColumnFamily>>(){

            @Override
            public Collection<ColumnFamily> apply(IMutation im) {
                return im.getColumnFamilies();
            }
        }));
        BatchStatement.verifyBatchSize(cfs);
        this.verifyBatchType(mutations);
        boolean mutateAtomic = this.type == Type.LOGGED && mutations.size() > 1;
        StorageProxy.mutateWithTriggers(mutations, cl, mutateAtomic);
    }

    private ResultMessage executeWithConditions(BatchQueryOptions options, QueryState state) throws RequestExecutionException, RequestValidationException {
        Pair<CQL3CasRequest, Set<ColumnDefinition>> p = this.makeCasRequest(options, state);
        CQL3CasRequest casRequest = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        ColumnFamily result = StorageProxy.cas(casRequest.cfm.ksName, casRequest.cfm.cfName, casRequest.key, casRequest, options.getSerialConsistency(), options.getConsistency(), state.getClientState());
        return new ResultMessage.Rows(ModificationStatement.buildCasResultSet(casRequest.cfm.ksName, casRequest.key, casRequest.cfm.cfName, result, columnsWithConditions, true, options.forStatement(0)));
    }

    private Pair<CQL3CasRequest, Set<ColumnDefinition>> makeCasRequest(BatchQueryOptions options, QueryState state) throws InvalidRequestException {
        long now = state.getTimestamp();
        ByteBuffer key = null;
        CQL3CasRequest casRequest = null;
        LinkedHashSet columnsWithConditions = new LinkedHashSet();
        for (int i = 0; i < this.statements.size(); ++i) {
            ModificationStatement statement = this.statements.get(i);
            QueryOptions statementOptions = options.forStatement(i);
            long timestamp = this.attrs.getTimestamp(now, statementOptions);
            List<ByteBuffer> pks = statement.buildPartitionKeyNames(statementOptions);
            if (pks.size() > 1) {
                throw new IllegalArgumentException("Batch with conditions cannot span multiple partitions (you cannot use IN on the partition key)");
            }
            if (key == null) {
                key = pks.get(0);
                casRequest = new CQL3CasRequest(statement.cfm, key, true);
            } else if (!key.equals(pks.get(0))) {
                throw new InvalidRequestException("Batch with conditions cannot span multiple partitions");
            }
            Composite clusteringPrefix = statement.createClusteringPrefix(statementOptions);
            if (statement.hasConditions()) {
                statement.addConditions(clusteringPrefix, casRequest, statementOptions);
                if (statement.hasIfNotExistCondition() || statement.hasIfExistCondition()) {
                    columnsWithConditions = null;
                } else if (columnsWithConditions != null) {
                    Iterables.addAll(columnsWithConditions, statement.getColumnsWithConditions());
                }
            }
            casRequest.addRowUpdate(clusteringPrefix, statement, statementOptions, timestamp);
        }
        return Pair.create(casRequest, columnsWithConditions);
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        if (this.hasConditions) {
            return this.executeInternalWithConditions(BatchQueryOptions.withoutPerStatementVariables(options), queryState);
        }
        this.executeInternalWithoutCondition(queryState, options);
        return new ResultMessage.Void();
    }

    private ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(BatchQueryOptions.withoutPerStatementVariables(options), true, queryState.getTimestamp())) {
            assert (iMutation instanceof Mutation || iMutation instanceof CounterMutation);
            if (iMutation instanceof Mutation) {
                ((Mutation)iMutation).apply();
                continue;
            }
            if (!(iMutation instanceof CounterMutation)) continue;
            ((CounterMutation)iMutation).apply();
        }
        return null;
    }

    private ResultMessage executeInternalWithConditions(BatchQueryOptions options, QueryState state) throws RequestExecutionException, RequestValidationException {
        Pair<CQL3CasRequest, Set<ColumnDefinition>> p = this.makeCasRequest(options, state);
        CQL3CasRequest request = (CQL3CasRequest)p.left;
        Set columnsWithConditions = (Set)p.right;
        ColumnFamily result = ModificationStatement.casInternal(request, state);
        return new ResultMessage.Rows(ModificationStatement.buildCasResultSet(request.cfm.ksName, request.key, request.cfm.cfName, result, columnsWithConditions, true, options.forStatement(0)));
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }

    public static class Parsed
    extends CFStatement {
        private final Type type;
        private final Attributes.Raw attrs;
        private final List<ModificationStatement.Parsed> parsedStatements;

        public Parsed(Type type, Attributes.Raw attrs, List<ModificationStatement.Parsed> parsedStatements) {
            super(null);
            this.type = type;
            this.attrs = attrs;
            this.parsedStatements = parsedStatements;
        }

        @Override
        public void prepareKeyspace(ClientState state) throws InvalidRequestException {
            for (ModificationStatement.Parsed statement : this.parsedStatements) {
                statement.prepareKeyspace(state);
            }
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.parsedStatements.size());
            for (ModificationStatement.Parsed parsed : this.parsedStatements) {
                statements.add(parsed.prepare(boundNames));
            }
            Attributes prepAttrs = this.attrs.prepare("[batch]", "[batch]");
            prepAttrs.collectMarkerSpecification(boundNames);
            BatchStatement batchStatement = new BatchStatement(boundNames.size(), this.type, statements, prepAttrs);
            batchStatement.validate();
            return new ParsedStatement.Prepared((CQLStatement)batchStatement, boundNames);
        }
    }

    public static interface BatchVariables {
        public List<ByteBuffer> getVariablesForStatement(int var1);
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

