/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.$internal.com.google.common.base.Function;
import org.apache.cassandra.$internal.com.google.common.collect.Iterables;
import org.apache.cassandra.$internal.com.google.common.collect.MapDifference;
import org.apache.cassandra.$internal.com.google.common.collect.Maps;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.UTMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefsTables {
    private static final Logger logger = LoggerFactory.getLogger(DefsTables.class);

    public static Collection<KSMetaData> loadFromKeyspace() {
        List<Row> serializedSchema = SystemKeyspace.serializedSchema("schema_keyspaces");
        ArrayList<KSMetaData> keyspaces = new ArrayList<KSMetaData>(serializedSchema.size());
        for (Row row : serializedSchema) {
            if (Schema.invalidSchemaRow(row) || Schema.ignoredSchemaRow(row)) continue;
            keyspaces.add(KSMetaData.fromSchema(row, DefsTables.serializedColumnFamilies(row.key), DefsTables.serializedUserTypes(row.key)));
        }
        return keyspaces;
    }

    private static Row serializedColumnFamilies(DecoratedKey ksNameKey) {
        ColumnFamilyStore cfsStore = SystemKeyspace.schemaCFS("schema_columnfamilies");
        return new Row(ksNameKey, cfsStore.getColumnFamily(QueryFilter.getIdentityFilter(ksNameKey, "schema_columnfamilies", System.currentTimeMillis())));
    }

    private static Row serializedUserTypes(DecoratedKey ksNameKey) {
        ColumnFamilyStore cfsStore = SystemKeyspace.schemaCFS("schema_usertypes");
        return new Row(ksNameKey, cfsStore.getColumnFamily(QueryFilter.getIdentityFilter(ksNameKey, "schema_usertypes", System.currentTimeMillis())));
    }

    public static synchronized void mergeSchema(Collection<Mutation> mutations) throws ConfigurationException, IOException {
        DefsTables.mergeSchemaInternal(mutations, true);
        Schema.instance.updateVersionAndAnnounce();
    }

    public static synchronized void mergeSchemaInternal(Collection<Mutation> mutations, boolean doFlush) throws ConfigurationException, IOException {
        HashSet<String> keyspaces = new HashSet<String>(mutations.size());
        for (Mutation mutation : mutations) {
            keyspaces.add(ByteBufferUtil.string(mutation.key()));
        }
        Map<DecoratedKey, ColumnFamily> oldKeyspaces = SystemKeyspace.getSchema("schema_keyspaces", keyspaces);
        Map<DecoratedKey, ColumnFamily> oldColumnFamilies = SystemKeyspace.getSchema("schema_columnfamilies", keyspaces);
        Map<DecoratedKey, ColumnFamily> oldTypes = SystemKeyspace.getSchema("schema_usertypes", keyspaces);
        for (Mutation mutation : mutations) {
            mutation.apply();
        }
        if (doFlush && !StorageService.instance.isClientMode()) {
            DefsTables.flushSchemaCFs();
        }
        Map<DecoratedKey, ColumnFamily> newKeyspaces = SystemKeyspace.getSchema("schema_keyspaces", keyspaces);
        Map<DecoratedKey, ColumnFamily> newColumnFamilies = SystemKeyspace.getSchema("schema_columnfamilies", keyspaces);
        Map<DecoratedKey, ColumnFamily> newTypes = SystemKeyspace.getSchema("schema_usertypes", keyspaces);
        Set<String> keyspacesToDrop = DefsTables.mergeKeyspaces(oldKeyspaces, newKeyspaces);
        DefsTables.mergeColumnFamilies(oldColumnFamilies, newColumnFamilies);
        DefsTables.mergeTypes(oldTypes, newTypes);
        for (String keyspaceToDrop : keyspacesToDrop) {
            DefsTables.dropKeyspace(keyspaceToDrop);
        }
    }

    private static Set<String> mergeKeyspaces(Map<DecoratedKey, ColumnFamily> before, Map<DecoratedKey, ColumnFamily> after) {
        ArrayList<Row> created = new ArrayList<Row>();
        ArrayList<String> altered = new ArrayList<String>();
        HashSet<String> dropped = new HashSet<String>();
        MapDifference<DecoratedKey, ColumnFamily> diff = Maps.difference(before, after);
        for (Map.Entry<DecoratedKey, ColumnFamily> entry : diff.entriesOnlyOnRight().entrySet()) {
            if (!entry.getValue().hasColumns()) continue;
            created.add(new Row(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<DecoratedKey, Object> entry : diff.entriesDiffering().entrySet()) {
            String keyspaceName = (String)AsciiType.instance.compose(entry.getKey().getKey());
            ColumnFamily pre = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily post = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (pre.hasColumns() && post.hasColumns()) {
                altered.add(keyspaceName);
                continue;
            }
            if (pre.hasColumns()) {
                dropped.add(keyspaceName);
                continue;
            }
            if (!post.hasColumns()) continue;
            created.add(new Row(entry.getKey(), post));
        }
        for (Row row : created) {
            DefsTables.addKeyspace(KSMetaData.fromSchema(row, Collections.emptyList(), new UTMetaData()));
        }
        for (String string : altered) {
            DefsTables.updateKeyspace(string);
        }
        return dropped;
    }

    private static void mergeColumnFamilies(Map<DecoratedKey, ColumnFamily> before, Map<DecoratedKey, ColumnFamily> after) {
        ArrayList<CFMetaData> created = new ArrayList<CFMetaData>();
        ArrayList altered = new ArrayList();
        ArrayList<CFMetaData> dropped = new ArrayList<CFMetaData>();
        MapDifference<DecoratedKey, ColumnFamily> diff = Maps.difference(before, after);
        for (Map.Entry<DecoratedKey, ColumnFamily> entry : diff.entriesOnlyOnRight().entrySet()) {
            if (!entry.getValue().hasColumns()) continue;
            created.addAll(KSMetaData.deserializeColumnFamilies(new Row(entry.getKey(), entry.getValue())).values());
        }
        for (Map.Entry<DecoratedKey, Object> entry : diff.entriesDiffering().entrySet()) {
            String keyspaceName = (String)AsciiType.instance.compose(entry.getKey().getKey());
            ColumnFamily pre = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily post = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (pre.hasColumns() && post.hasColumns()) {
                MapDifference<String, CFMetaData> delta = Maps.difference(Schema.instance.getKSMetaData(keyspaceName).cfMetaData(), KSMetaData.deserializeColumnFamilies(new Row(entry.getKey(), post)));
                dropped.addAll(delta.entriesOnlyOnLeft().values());
                created.addAll(delta.entriesOnlyOnRight().values());
                Iterables.addAll(altered, Iterables.transform(delta.entriesDiffering().values(), new Function<MapDifference.ValueDifference<CFMetaData>, CFMetaData>(){

                    @Override
                    public CFMetaData apply(MapDifference.ValueDifference<CFMetaData> pair) {
                        return pair.rightValue();
                    }
                }));
                continue;
            }
            if (pre.hasColumns()) {
                dropped.addAll(Schema.instance.getKSMetaData(keyspaceName).cfMetaData().values());
                continue;
            }
            if (!post.hasColumns()) continue;
            created.addAll(KSMetaData.deserializeColumnFamilies(new Row(entry.getKey(), post)).values());
        }
        for (CFMetaData cFMetaData : created) {
            DefsTables.addColumnFamily(cFMetaData);
        }
        for (CFMetaData cFMetaData : altered) {
            DefsTables.updateColumnFamily(cFMetaData.ksName, cFMetaData.cfName);
        }
        for (CFMetaData cFMetaData : dropped) {
            DefsTables.dropColumnFamily(cFMetaData.ksName, cFMetaData.cfName);
        }
    }

    private static void mergeTypes(Map<DecoratedKey, ColumnFamily> before, Map<DecoratedKey, ColumnFamily> after) {
        ArrayList<UserType> created = new ArrayList<UserType>();
        ArrayList altered = new ArrayList();
        ArrayList<UserType> dropped = new ArrayList<UserType>();
        MapDifference<DecoratedKey, ColumnFamily> diff = Maps.difference(before, after);
        for (Map.Entry<DecoratedKey, ColumnFamily> entry : diff.entriesOnlyOnRight().entrySet()) {
            if (!entry.getValue().hasColumns()) continue;
            created.addAll(UTMetaData.fromSchema(new Row(entry.getKey(), entry.getValue())).values());
        }
        for (Map.Entry<DecoratedKey, Object> entry : diff.entriesDiffering().entrySet()) {
            String keyspaceName = (String)AsciiType.instance.compose(entry.getKey().getKey());
            ColumnFamily pre = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily post = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (pre.hasColumns() && post.hasColumns()) {
                MapDifference<ByteBuffer, UserType> delta = Maps.difference(Schema.instance.getKSMetaData((String)keyspaceName).userTypes.getAllTypes(), UTMetaData.fromSchema(new Row(entry.getKey(), post)));
                dropped.addAll(delta.entriesOnlyOnLeft().values());
                created.addAll(delta.entriesOnlyOnRight().values());
                Iterables.addAll(altered, Iterables.transform(delta.entriesDiffering().values(), new Function<MapDifference.ValueDifference<UserType>, UserType>(){

                    @Override
                    public UserType apply(MapDifference.ValueDifference<UserType> pair) {
                        return pair.rightValue();
                    }
                }));
                continue;
            }
            if (pre.hasColumns()) {
                dropped.addAll(Schema.instance.getKSMetaData((String)keyspaceName).userTypes.getAllTypes().values());
                continue;
            }
            if (!post.hasColumns()) continue;
            created.addAll(UTMetaData.fromSchema(new Row(entry.getKey(), post)).values());
        }
        for (UserType userType : created) {
            DefsTables.addType(userType);
        }
        for (UserType userType : altered) {
            DefsTables.updateType(userType);
        }
        for (UserType userType : dropped) {
            DefsTables.dropType(userType);
        }
    }

    private static void addKeyspace(KSMetaData ksm) {
        assert (Schema.instance.getKSMetaData(ksm.name) == null);
        Schema.instance.load(ksm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(ksm.name);
            MigrationManager.instance.notifyCreateKeyspace(ksm);
        }
    }

    private static void addColumnFamily(CFMetaData cfm) {
        assert (Schema.instance.getCFMetaData(cfm.ksName, cfm.cfName) == null);
        KSMetaData ksm = Schema.instance.getKSMetaData(cfm.ksName);
        ksm = KSMetaData.cloneWith(ksm, Iterables.concat(ksm.cfMetaData().values(), Collections.singleton(cfm)));
        logger.info("Loading {}", (Object)cfm);
        Schema.instance.load(cfm);
        Keyspace.open(cfm.ksName);
        Schema.instance.setKeyspaceDefinition(ksm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(ksm.name).initCf(cfm.cfId, cfm.cfName, true);
            MigrationManager.instance.notifyCreateColumnFamily(cfm);
        }
    }

    private static void addType(UserType ut) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        logger.info("Loading {}", (Object)ut);
        ksm.userTypes.addType(ut);
        if (!StorageService.instance.isClientMode()) {
            MigrationManager.instance.notifyCreateUserType(ut);
        }
    }

    private static void updateKeyspace(String ksName) {
        KSMetaData oldKsm = Schema.instance.getKSMetaData(ksName);
        assert (oldKsm != null);
        KSMetaData newKsm = KSMetaData.cloneWith(oldKsm.reloadAttributes(), oldKsm.cfMetaData().values());
        Schema.instance.setKeyspaceDefinition(newKsm);
        if (!StorageService.instance.isClientMode()) {
            Keyspace.open(ksName).setMetadata(newKsm);
            MigrationManager.instance.notifyUpdateKeyspace(newKsm);
        }
    }

    private static void updateColumnFamily(String ksName, String cfName) {
        CFMetaData cfm = Schema.instance.getCFMetaData(ksName, cfName);
        assert (cfm != null);
        boolean columnsDidChange = cfm.reload();
        if (!StorageService.instance.isClientMode()) {
            Keyspace keyspace = Keyspace.open(cfm.ksName);
            keyspace.getColumnFamilyStore(cfm.cfName).reload();
            MigrationManager.instance.notifyUpdateColumnFamily(cfm, columnsDidChange);
        }
    }

    private static void updateType(UserType ut) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        logger.info("Updating {}", (Object)ut);
        ksm.userTypes.addType(ut);
        if (!StorageService.instance.isClientMode()) {
            MigrationManager.instance.notifyUpdateUserType(ut);
        }
    }

    private static void dropKeyspace(String ksName) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ksName);
        String snapshotName = Keyspace.getTimestampedSnapshotName(ksName);
        CompactionManager.instance.interruptCompactionFor(ksm.cfMetaData().values(), true);
        Keyspace keyspace = Keyspace.open(ksm.name);
        ArrayList<UUID> droppedCfs = new ArrayList<UUID>();
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(cfm.cfName);
            Schema.instance.purge(cfm);
            if (!StorageService.instance.isClientMode()) {
                if (DatabaseDescriptor.isAutoSnapshot()) {
                    cfs.snapshot(snapshotName);
                }
                Keyspace.open(ksm.name).dropCf(cfm.cfId);
            }
            droppedCfs.add(cfm.cfId);
        }
        Keyspace.clear(ksm.name);
        Schema.instance.clearKeyspaceDefinition(ksm);
        keyspace.writeOrder.awaitNewBarrier();
        CommitLog.instance.forceRecycleAllSegments(droppedCfs);
        if (!StorageService.instance.isClientMode()) {
            MigrationManager.instance.notifyDropKeyspace(ksm);
        }
    }

    private static void dropColumnFamily(String ksName, String cfName) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ksName);
        assert (ksm != null);
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        assert (cfs != null);
        CFMetaData cfm = ksm.cfMetaData().get(cfName);
        Schema.instance.purge(cfm);
        Schema.instance.setKeyspaceDefinition(DefsTables.makeNewKeyspaceDefinition(ksm, cfm));
        CompactionManager.instance.interruptCompactionFor(Arrays.asList(cfm), true);
        if (!StorageService.instance.isClientMode()) {
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(Keyspace.getTimestampedSnapshotName(cfs.name));
            }
            Keyspace.open(ksm.name).dropCf(cfm.cfId);
            MigrationManager.instance.notifyDropColumnFamily(cfm);
            CommitLog.instance.forceRecycleAllSegments(Collections.singleton(cfm.cfId));
        }
    }

    private static void dropType(UserType ut) {
        KSMetaData ksm = Schema.instance.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        ksm.userTypes.removeType(ut);
        if (!StorageService.instance.isClientMode()) {
            MigrationManager.instance.notifyDropUserType(ut);
        }
    }

    private static KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm, CFMetaData toExclude) {
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.remove(toExclude);
        assert (newCfs.size() == ksm.cfMetaData().size() - 1);
        return KSMetaData.cloneWith(ksm, newCfs);
    }

    private static void flushSchemaCFs() {
        for (String cf : SystemKeyspace.allSchemaCfs) {
            SystemKeyspace.forceBlockingFlush(cf);
        }
    }
}

