/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.$internal.com.google.common.base.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RetriedSliceFromReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommandSerializer;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceFromReadCommand
extends ReadCommand {
    private static final Logger logger = LoggerFactory.getLogger(SliceFromReadCommand.class);
    static final SliceFromReadCommandSerializer serializer = new SliceFromReadCommandSerializer();
    public final SliceQueryFilter filter;

    public SliceFromReadCommand(String keyspaceName, ByteBuffer key, String cfName, long timestamp, SliceQueryFilter filter) {
        super(keyspaceName, key, cfName, timestamp, ReadCommand.Type.GET_SLICES);
        this.filter = filter;
    }

    @Override
    public ReadCommand copy() {
        return new SliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, this.filter).setIsDigestQuery(this.isDigestQuery());
    }

    @Override
    public Row getRow(Keyspace keyspace) {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.ksName, this.cfName);
        DecoratedKey dk = StorageService.getPartitioner().decorateKey(this.key);
        if (this.filter.reversed && this.filter.hasStaticSlice(cfm)) {
            logger.debug("Splitting reversed slice with static columns into two reads");
            Pair<SliceQueryFilter, SliceQueryFilter> newFilters = this.filter.splitOutStaticSlice(cfm);
            Row normalResults = keyspace.getRow(new QueryFilter(dk, this.cfName, (IDiskAtomFilter)newFilters.right, this.timestamp));
            Row staticResults = keyspace.getRow(new QueryFilter(dk, this.cfName, (IDiskAtomFilter)newFilters.left, this.timestamp));
            if (normalResults.cf == null) {
                return staticResults;
            }
            if (staticResults.cf != null) {
                for (Cell cell : staticResults.cf.getReverseSortedColumns()) {
                    normalResults.cf.addColumn(cell);
                }
            }
            return normalResults;
        }
        return keyspace.getRow(new QueryFilter(dk, this.cfName, this.filter, this.timestamp));
    }

    @Override
    public ReadCommand maybeGenerateRetryCommand(RowDataResolver resolver, Row row) {
        int liveCountInRow;
        int count;
        int maxLiveColumns = resolver.getMaxLiveCount();
        if (maxLiveColumns < (count = this.filter.count)) {
            return null;
        }
        int n = liveCountInRow = row == null || row.cf == null ? 0 : this.filter.getLiveCount(row.cf, this.timestamp);
        if (liveCountInRow < this.getOriginalRequestedCount()) {
            int retryCount = liveCountInRow == 0 ? count + 1 : count * count / liveCountInRow + 1;
            SliceQueryFilter newFilter = this.filter.withUpdatedCount(retryCount);
            return new RetriedSliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, newFilter, this.getOriginalRequestedCount());
        }
        return null;
    }

    @Override
    public Row maybeTrim(Row row) {
        if (row == null || row.cf == null) {
            return row;
        }
        return new Row(row.key, this.filter.trim(row.cf, this.getOriginalRequestedCount(), this.timestamp));
    }

    @Override
    public IDiskAtomFilter filter() {
        return this.filter;
    }

    public SliceFromReadCommand withUpdatedFilter(SliceQueryFilter newFilter) {
        return new SliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, newFilter);
    }

    protected int getOriginalRequestedCount() {
        return this.filter.count;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("ksName", this.ksName).add("cfName", this.cfName).add("key", ByteBufferUtil.bytesToHex(this.key)).add("filter", this.filter).add("timestamp", this.timestamp).toString();
    }
}

