/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOException;
import org.apache.cassandra.$internal.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;

public class LazyColumnIterator
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private final DecoratedKey key;
    private final IColumnIteratorFactory subIteratorFactory;
    private OnDiskAtomIterator subIterator;

    public LazyColumnIterator(DecoratedKey key, IColumnIteratorFactory subIteratorFactory) {
        this.key = key;
        this.subIteratorFactory = subIteratorFactory;
    }

    private OnDiskAtomIterator getSubIterator() {
        if (this.subIterator == null) {
            this.subIterator = this.subIteratorFactory.create();
        }
        return this.subIterator;
    }

    @Override
    protected OnDiskAtom computeNext() {
        this.getSubIterator();
        return this.subIterator.hasNext() ? (OnDiskAtom)this.subIterator.next() : (OnDiskAtom)this.endOfData();
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.getSubIterator().getColumnFamily();
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public void close() throws IOException {
        if (this.subIterator != null) {
            this.subIterator.close();
        }
    }
}

