/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.;
import org.apache.cassandra.$internal.com.google.common.base.Predicate;
import org.apache.cassandra.$internal.com.google.common.collect.ImmutableList;
import org.apache.cassandra.$internal.com.google.common.collect.Iterables;
import org.apache.cassandra.$internal.com.google.common.collect.Iterators;
import org.apache.cassandra.$internal.com.google.common.collect.Lists;
import org.apache.cassandra.$internal.com.google.common.collect.PeekingIterator;
import org.apache.cassandra.$internal.com.google.common.collect.Sets;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.DateTieredCompactionStrategyOptions;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategyOptions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTieredCompactionStrategy
extends AbstractCompactionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DateTieredCompactionStrategy.class);
    private final DateTieredCompactionStrategyOptions options;
    protected volatile int estimatedRemainingTasks = 0;
    private final Set<SSTableReader> sstables = new HashSet<SSTableReader>();
    private long lastExpiredCheck;
    private final SizeTieredCompactionStrategyOptions stcsOptions;

    public DateTieredCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        super(cfs, options);
        this.options = new DateTieredCompactionStrategyOptions(options);
        if (!options.containsKey("tombstone_compaction_interval") && !options.containsKey("tombstone_threshold")) {
            this.disableTombstoneCompactions = true;
            logger.debug("Disabling tombstone compactions for DTCS");
        } else {
            logger.debug("Enabling tombstone compactions for DTCS");
        }
        this.stcsOptions = new SizeTieredCompactionStrategyOptions(options);
    }

    @Override
    public synchronized AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        List<SSTableReader> latestBucket;
        do {
            if (!(latestBucket = this.getNextBackgroundSSTables(gcBefore)).isEmpty()) continue;
            return null;
        } while (!this.cfs.getDataTracker().markCompacting(latestBucket));
        return new CompactionTask(this.cfs, latestBucket, gcBefore, false);
    }

    private List<SSTableReader> getNextBackgroundSSTables(int gcBefore) {
        if (this.cfs.getSSTables().isEmpty()) {
            return Collections.emptyList();
        }
        Sets.SetView<SSTableReader> uncompacting = Sets.intersection(this.sstables, this.cfs.getUncompactingSSTables());
        Set<Object> expired = Collections.emptySet();
        if (System.currentTimeMillis() - this.lastExpiredCheck > this.options.expiredSSTableCheckFrequency) {
            expired = CompactionController.getFullyExpiredSSTables(this.cfs, uncompacting, this.cfs.getOverlappingSSTables(uncompacting), gcBefore);
            this.lastExpiredCheck = System.currentTimeMillis();
        }
        HashSet<SSTableReader> candidates = Sets.newHashSet(DateTieredCompactionStrategy.filterSuspectSSTables(uncompacting));
        ArrayList<SSTableReader> compactionCandidates = new ArrayList<SSTableReader>(this.getNextNonExpiredSSTables(Sets.difference(candidates, expired), gcBefore));
        if (!expired.isEmpty()) {
            logger.debug("Including expired sstables: {}", expired);
            compactionCandidates.addAll(expired);
        }
        return compactionCandidates;
    }

    private List<SSTableReader> getNextNonExpiredSSTables(Iterable<SSTableReader> nonExpiringSSTables, int gcBefore) {
        int base = this.cfs.getMinimumCompactionThreshold();
        long now = this.getNow();
        List<SSTableReader> mostInteresting = this.getCompactionCandidates(nonExpiringSSTables, now, base);
        if (mostInteresting != null) {
            return mostInteresting;
        }
        ArrayList<SSTableReader> sstablesWithTombstones = Lists.newArrayList();
        for (SSTableReader sstable : nonExpiringSSTables) {
            if (!this.worthDroppingTombstones(sstable, gcBefore)) continue;
            sstablesWithTombstones.add(sstable);
        }
        if (sstablesWithTombstones.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Collections.min(sstablesWithTombstones, new SSTableReader.SizeComparator()));
    }

    private List<SSTableReader> getCompactionCandidates(Iterable<SSTableReader> candidateSSTables, long now, int base) {
        Iterable<SSTableReader> candidates = DateTieredCompactionStrategy.filterOldSSTables(Lists.newArrayList(candidateSSTables), this.options.maxSSTableAge, now);
        List<List<SSTableReader>> buckets = DateTieredCompactionStrategy.getBuckets(DateTieredCompactionStrategy.createSSTableAndMinTimestampPairs(candidates), this.options.baseTime, base, now, this.options.maxWindowSize);
        logger.debug("Compaction buckets are {}", buckets);
        this.updateEstimatedCompactionsByTasks(buckets);
        List<SSTableReader> mostInteresting = DateTieredCompactionStrategy.newestBucket(buckets, this.cfs.getMinimumCompactionThreshold(), this.cfs.getMaximumCompactionThreshold(), now, this.options.baseTime, this.options.maxWindowSize, this.stcsOptions);
        if (!mostInteresting.isEmpty()) {
            return mostInteresting;
        }
        return null;
    }

    private long getNow() {
        return Collections.max(this.cfs.getSSTables(), new Comparator<SSTableReader>(){

            @Override
            public int compare(SSTableReader o1, SSTableReader o2) {
                return Long.compare(o1.getMaxTimestamp(), o2.getMaxTimestamp());
            }
        }).getMaxTimestamp();
    }

    @.VisibleForTesting
    static Iterable<SSTableReader> filterOldSSTables(List<SSTableReader> sstables, long maxSSTableAge, long now) {
        if (maxSSTableAge == 0L) {
            return sstables;
        }
        final long cutoff = now - maxSSTableAge;
        return Iterables.filter(sstables, new Predicate<SSTableReader>(){

            @Override
            public boolean apply(SSTableReader sstable) {
                return sstable.getMaxTimestamp() >= cutoff;
            }
        });
    }

    public static List<Pair<SSTableReader, Long>> createSSTableAndMinTimestampPairs(Iterable<SSTableReader> sstables) {
        ArrayList<Pair<SSTableReader, Long>> sstableMinTimestampPairs = Lists.newArrayListWithCapacity(Iterables.size(sstables));
        for (SSTableReader sstable : sstables) {
            sstableMinTimestampPairs.add(Pair.create(sstable, sstable.getMinTimestamp()));
        }
        return sstableMinTimestampPairs;
    }

    @Override
    public void addSSTable(SSTableReader sstable) {
        this.sstables.add(sstable);
    }

    @Override
    public void removeSSTable(SSTableReader sstable) {
        this.sstables.remove(sstable);
    }

    @.VisibleForTesting
    static <T> List<List<T>> getBuckets(Collection<Pair<T, Long>> files, long timeUnit, int base, long now, long maxWindowSize) {
        ArrayList<Pair<T, Long>> sortedFiles = Lists.newArrayList(files);
        Collections.sort(sortedFiles, Collections.reverseOrder(new Comparator<Pair<T, Long>>(){

            @Override
            public int compare(Pair<T, Long> p1, Pair<T, Long> p2) {
                return ((Long)p1.right).compareTo((Long)p2.right);
            }
        }));
        ArrayList<List<T>> buckets = Lists.newArrayList();
        Target target = DateTieredCompactionStrategy.getInitialTarget(now, timeUnit, maxWindowSize);
        PeekingIterator it = Iterators.peekingIterator(sortedFiles.iterator());
        block0: while (it.hasNext()) {
            while (!target.onTarget((Long)((Pair)it.peek()).right)) {
                if (target.compareToTimestamp((Long)((Pair)it.peek()).right) < 0) {
                    it.next();
                    if (it.hasNext()) continue;
                    break block0;
                }
                target = target.nextTarget(base);
            }
            ArrayList bucket = Lists.newArrayList();
            while (target.onTarget((Long)((Pair)it.peek()).right)) {
                bucket.add(((Pair)it.next()).left);
                if (it.hasNext()) continue;
            }
            buckets.add(bucket);
        }
        return buckets;
    }

    @.VisibleForTesting
    static Target getInitialTarget(long now, long timeUnit, long maxWindowSize) {
        return new Target(timeUnit, now / timeUnit, maxWindowSize);
    }

    private void updateEstimatedCompactionsByTasks(List<List<SSTableReader>> tasks) {
        int n = 0;
        for (List<SSTableReader> bucket : tasks) {
            for (List<SSTableReader> stcsBucket : DateTieredCompactionStrategy.getSTCSBuckets(bucket, this.stcsOptions)) {
                if (stcsBucket.size() < this.cfs.getMinimumCompactionThreshold()) continue;
                n = (int)((double)n + Math.ceil((double)stcsBucket.size() / (double)this.cfs.getMaximumCompactionThreshold()));
            }
        }
        this.estimatedRemainingTasks = n;
    }

    @.VisibleForTesting
    static List<SSTableReader> newestBucket(List<List<SSTableReader>> buckets, int minThreshold, int maxThreshold, long now, long baseTime, long maxWindowSize, SizeTieredCompactionStrategyOptions stcsOptions) {
        Target incomingWindow = DateTieredCompactionStrategy.getInitialTarget(now, baseTime, maxWindowSize);
        for (List<SSTableReader> bucket : buckets) {
            List<SSTableReader> stcsSSTables;
            boolean inFirstWindow = incomingWindow.onTarget(bucket.get(0).getMinTimestamp());
            if (bucket.size() < minThreshold && (bucket.size() < 2 || inFirstWindow) || (stcsSSTables = DateTieredCompactionStrategy.getSSTablesForSTCS(bucket, inFirstWindow ? minThreshold : 2, maxThreshold, stcsOptions)).isEmpty()) continue;
            return stcsSSTables;
        }
        return Collections.emptyList();
    }

    private static List<SSTableReader> getSSTablesForSTCS(Collection<SSTableReader> sstables, int minThreshold, int maxThreshold, SizeTieredCompactionStrategyOptions stcsOptions) {
        List<SSTableReader> s = SizeTieredCompactionStrategy.mostInterestingBucket(DateTieredCompactionStrategy.getSTCSBuckets(sstables, stcsOptions), minThreshold, maxThreshold);
        logger.debug("Got sstables {} for STCS from {}", s, sstables);
        return s;
    }

    private static List<List<SSTableReader>> getSTCSBuckets(Collection<SSTableReader> sstables, SizeTieredCompactionStrategyOptions stcsOptions) {
        List pairs = SizeTieredCompactionStrategy.createSSTableAndLengthPairs(AbstractCompactionStrategy.filterSuspectSSTables(sstables));
        return SizeTieredCompactionStrategy.getBuckets(pairs, stcsOptions.bucketHigh, stcsOptions.bucketLow, stcsOptions.minSSTableSize);
    }

    @Override
    public synchronized Collection<AbstractCompactionTask> getMaximalTask(int gcBefore) {
        Iterable<SSTableReader> filteredSSTables = DateTieredCompactionStrategy.filterSuspectSSTables(this.sstables);
        if (Iterables.isEmpty(filteredSSTables)) {
            return null;
        }
        if (!this.cfs.getDataTracker().markCompacting(ImmutableList.copyOf(filteredSSTables))) {
            return null;
        }
        return Collections.singleton(new CompactionTask(this.cfs, filteredSSTables, gcBefore, false));
    }

    @Override
    public synchronized AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        assert (!sstables.isEmpty());
        if (!this.cfs.getDataTracker().markCompacting(sstables)) {
            logger.debug("Unable to mark {} for compaction; probably a background compaction got to it first.  You can disable background compactions temporarily if this is a problem", sstables);
            return null;
        }
        return new CompactionTask(this.cfs, sstables, gcBefore, false).setUserDefined(true);
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return this.estimatedRemainingTasks;
    }

    @Override
    public long getMaxSSTableBytes() {
        return Long.MAX_VALUE;
    }

    public static Map<String, String> validateOptions(Map<String, String> options) throws ConfigurationException {
        Map<String, String> uncheckedOptions = AbstractCompactionStrategy.validateOptions(options);
        uncheckedOptions = DateTieredCompactionStrategyOptions.validateOptions(options, uncheckedOptions);
        uncheckedOptions.remove("min_threshold");
        uncheckedOptions.remove("max_threshold");
        uncheckedOptions = SizeTieredCompactionStrategyOptions.validateOptions(options, uncheckedOptions);
        return uncheckedOptions;
    }

    public String toString() {
        return String.format("DateTieredCompactionStrategy[%s/%s]", this.cfs.getMinimumCompactionThreshold(), this.cfs.getMaximumCompactionThreshold());
    }

    private static class Target {
        public final long size;
        public final long divPosition;
        public final long maxWindowSize;

        public Target(long size, long divPosition, long maxWindowSize) {
            this.size = size;
            this.divPosition = divPosition;
            this.maxWindowSize = maxWindowSize;
        }

        public int compareToTimestamp(long timestamp) {
            return Long.compare(this.divPosition, timestamp / this.size);
        }

        public boolean onTarget(long timestamp) {
            return this.compareToTimestamp(timestamp) == 0;
        }

        public Target nextTarget(int base) {
            if (this.divPosition % (long)base > 0L || this.size * (long)base > this.maxWindowSize) {
                return new Target(this.size, this.divPosition - 1L, this.maxWindowSize);
            }
            return new Target(this.size * (long)base, this.divPosition / (long)base - 1L, this.maxWindowSize);
        }
    }
}

