/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.cassandra.$internal.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WrappingCompactionStrategy
extends AbstractCompactionStrategy
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(WrappingCompactionStrategy.class);
    private volatile AbstractCompactionStrategy repaired;
    private volatile AbstractCompactionStrategy unrepaired;
    private Map<String, String> schemaCompactionOptions;
    private Class<?> schemaCompactionStrategyClass;

    public WrappingCompactionStrategy(ColumnFamilyStore cfs) {
        super(cfs, cfs.metadata.compactionStrategyOptions);
        this.reloadCompactionStrategy(cfs.metadata);
        cfs.getDataTracker().subscribe(this);
        logger.debug("{} subscribed to the data tracker.", (Object)this);
    }

    @Override
    public synchronized AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.repaired.getEstimatedRemainingTasks() > this.unrepaired.getEstimatedRemainingTasks()) {
            AbstractCompactionTask repairedTask = this.repaired.getNextBackgroundTask(gcBefore);
            if (repairedTask != null) {
                return repairedTask;
            }
            return this.unrepaired.getNextBackgroundTask(gcBefore);
        }
        AbstractCompactionTask unrepairedTask = this.unrepaired.getNextBackgroundTask(gcBefore);
        if (unrepairedTask != null) {
            return unrepairedTask;
        }
        return this.repaired.getNextBackgroundTask(gcBefore);
    }

    @Override
    public Collection<AbstractCompactionTask> getMaximalTask(final int gcBefore) {
        return this.cfs.runWithCompactionsDisabled(new Callable<Collection<AbstractCompactionTask>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<AbstractCompactionTask> call() throws Exception {
                WrappingCompactionStrategy wrappingCompactionStrategy = WrappingCompactionStrategy.this;
                synchronized (wrappingCompactionStrategy) {
                    Collection<AbstractCompactionTask> repairedTasks = WrappingCompactionStrategy.this.repaired.getMaximalTask(gcBefore);
                    Collection<AbstractCompactionTask> unrepairedTasks = WrappingCompactionStrategy.this.unrepaired.getMaximalTask(gcBefore);
                    if (repairedTasks == null && unrepairedTasks == null) {
                        return null;
                    }
                    if (repairedTasks == null) {
                        return unrepairedTasks;
                    }
                    if (unrepairedTasks == null) {
                        return repairedTasks;
                    }
                    ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
                    tasks.addAll(repairedTasks);
                    tasks.addAll(unrepairedTasks);
                    return tasks;
                }
            }
        }, false);
    }

    @Override
    public AbstractCompactionTask getCompactionTask(Collection<SSTableReader> sstables, int gcBefore, long maxSSTableBytes) {
        assert (sstables.size() > 0);
        boolean repairedSSTables = sstables.iterator().next().isRepaired();
        for (SSTableReader sstable : sstables) {
            if (repairedSSTables == sstable.isRepaired()) continue;
            throw new RuntimeException("Can't mix repaired and unrepaired sstables in a compaction");
        }
        if (repairedSSTables) {
            return this.repaired.getCompactionTask(sstables, gcBefore, maxSSTableBytes);
        }
        return this.unrepaired.getCompactionTask(sstables, gcBefore, maxSSTableBytes);
    }

    @Override
    public synchronized AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        assert (!sstables.isEmpty());
        boolean userDefinedInRepaired = sstables.iterator().next().isRepaired();
        for (SSTableReader sstable : sstables) {
            if (userDefinedInRepaired == sstable.isRepaired()) continue;
            logger.error("You can't mix repaired and unrepaired sstables in a user defined compaction");
            return null;
        }
        if (userDefinedInRepaired) {
            return this.repaired.getUserDefinedTask(sstables, gcBefore);
        }
        return this.unrepaired.getUserDefinedTask(sstables, gcBefore);
    }

    @Override
    public synchronized int getEstimatedRemainingTasks() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.repaired.getEstimatedRemainingTasks() + this.unrepaired.getEstimatedRemainingTasks();
    }

    @Override
    public synchronized long getMaxSSTableBytes() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.unrepaired.getMaxSSTableBytes();
    }

    public synchronized void maybeReloadCompactionStrategy(CFMetaData metadata) {
        if (metadata.compactionStrategyClass.equals(this.schemaCompactionStrategyClass) && metadata.compactionStrategyOptions.equals(this.schemaCompactionOptions)) {
            return;
        }
        this.reloadCompactionStrategy(metadata);
    }

    public synchronized void reloadCompactionStrategy(CFMetaData metadata) {
        boolean disabledWithJMX = !this.enabled && this.shouldBeEnabled();
        this.setStrategy(metadata.compactionStrategyClass, metadata.compactionStrategyOptions);
        this.schemaCompactionOptions = ImmutableMap.copyOf(metadata.compactionStrategyOptions);
        this.schemaCompactionStrategyClass = this.repaired.getClass();
        if (disabledWithJMX || !this.shouldBeEnabled()) {
            this.disable();
        } else {
            this.enable();
        }
        this.startup();
    }

    public synchronized int getUnleveledSSTables() {
        if (this.repaired instanceof LeveledCompactionStrategy && this.unrepaired instanceof LeveledCompactionStrategy) {
            return ((LeveledCompactionStrategy)this.repaired).getLevelSize(0) + ((LeveledCompactionStrategy)this.unrepaired).getLevelSize(0);
        }
        return 0;
    }

    public synchronized int[] getSSTableCountPerLevel() {
        if (this.repaired instanceof LeveledCompactionStrategy && this.unrepaired instanceof LeveledCompactionStrategy) {
            int[] repairedCountPerLevel = ((LeveledCompactionStrategy)this.repaired).getAllLevelSize();
            int[] unrepairedCountPerLevel = ((LeveledCompactionStrategy)this.unrepaired).getAllLevelSize();
            return WrappingCompactionStrategy.sumArrays(repairedCountPerLevel, unrepairedCountPerLevel);
        }
        return null;
    }

    public static int[] sumArrays(int[] a, int[] b) {
        int[] res = new int[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    @Override
    public boolean shouldDefragment() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.repaired.shouldDefragment();
    }

    @Override
    public String getName() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.repaired.getName();
    }

    @Override
    public void replaceSSTables(Collection<SSTableReader> removed, Collection<SSTableReader> added) {
        throw new UnsupportedOperationException("Can't replace sstables in the wrapping compaction strategy");
    }

    @Override
    public void addSSTable(SSTableReader added) {
        throw new UnsupportedOperationException("Can't add sstables to the wrapping compaction strategy");
    }

    @Override
    public void removeSSTable(SSTableReader sstable) {
        throw new UnsupportedOperationException("Can't remove sstables from the wrapping compaction strategy");
    }

    @Override
    public synchronized void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            if (flushedNotification.added.isRepaired()) {
                this.repaired.addSSTable(flushedNotification.added);
            } else {
                this.unrepaired.addSSTable(flushedNotification.added);
            }
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            HashSet<SSTableReader> repairedRemoved = new HashSet<SSTableReader>();
            HashSet<SSTableReader> repairedAdded = new HashSet<SSTableReader>();
            HashSet<SSTableReader> unrepairedRemoved = new HashSet<SSTableReader>();
            HashSet<SSTableReader> unrepairedAdded = new HashSet<SSTableReader>();
            for (SSTableReader sstable : listChangedNotification.removed) {
                if (sstable.isRepaired()) {
                    repairedRemoved.add(sstable);
                    continue;
                }
                unrepairedRemoved.add(sstable);
            }
            for (SSTableReader sstable : listChangedNotification.added) {
                if (sstable.isRepaired()) {
                    repairedAdded.add(sstable);
                    continue;
                }
                unrepairedAdded.add(sstable);
            }
            if (!repairedRemoved.isEmpty()) {
                this.repaired.replaceSSTables(repairedRemoved, repairedAdded);
            } else {
                for (SSTableReader sstable : repairedAdded) {
                    this.repaired.addSSTable(sstable);
                }
            }
            if (!unrepairedRemoved.isEmpty()) {
                this.unrepaired.replaceSSTables(unrepairedRemoved, unrepairedAdded);
            } else {
                for (SSTableReader sstable : unrepairedAdded) {
                    this.unrepaired.addSSTable(sstable);
                }
            }
        } else if (notification instanceof SSTableRepairStatusChanged) {
            for (SSTableReader sstable : ((SSTableRepairStatusChanged)notification).sstable) {
                if (sstable.isRepaired()) {
                    this.unrepaired.removeSSTable(sstable);
                    this.repaired.addSSTable(sstable);
                    continue;
                }
                this.repaired.removeSSTable(sstable);
                this.unrepaired.addSSTable(sstable);
            }
        } else if (notification instanceof SSTableDeletingNotification) {
            SSTableReader sstable = ((SSTableDeletingNotification)notification).deleting;
            if (sstable.isRepaired()) {
                this.repaired.removeSSTable(sstable);
            } else {
                this.unrepaired.removeSSTable(sstable);
            }
        }
    }

    @Override
    public List<SSTableReader> filterSSTablesForReads(List<SSTableReader> sstables) {
        return this.unrepaired.filterSSTablesForReads(this.repaired.filterSSTablesForReads(sstables));
    }

    @Override
    public synchronized void startup() {
        super.startup();
        for (SSTableReader sstable : this.cfs.getSSTables()) {
            if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
            if (sstable.isRepaired()) {
                this.repaired.addSSTable(sstable);
                continue;
            }
            this.unrepaired.addSSTable(sstable);
        }
        this.repaired.startup();
        this.unrepaired.startup();
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.repaired.shutdown();
        this.unrepaired.shutdown();
    }

    @Override
    public void enable() {
        if (this.repaired != null) {
            this.repaired.enable();
        }
        if (this.unrepaired != null) {
            this.unrepaired.enable();
        }
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
        if (this.repaired != null) {
            this.repaired.disable();
        }
        if (this.unrepaired != null) {
            this.unrepaired.disable();
        }
    }

    @Override
    public synchronized AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables, Range<Token> range) {
        ArrayList<SSTableReader> repairedSSTables = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> unrepairedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : sstables) {
            if (sstable.isRepaired()) {
                repairedSSTables.add(sstable);
                continue;
            }
            unrepairedSSTables.add(sstable);
        }
        AbstractCompactionStrategy.ScannerList repairedScanners = this.repaired.getScanners(repairedSSTables, range);
        AbstractCompactionStrategy.ScannerList unrepairedScanners = this.unrepaired.getScanners(unrepairedSSTables, range);
        ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(repairedScanners.scanners.size() + unrepairedScanners.scanners.size());
        scanners.addAll(repairedScanners.scanners);
        scanners.addAll(unrepairedScanners.scanners);
        return new AbstractCompactionStrategy.ScannerList(scanners);
    }

    public List<AbstractCompactionStrategy> getWrappedStrategies() {
        return Arrays.asList(this.repaired, this.unrepaired);
    }

    public synchronized void setNewLocalCompactionStrategy(Class<? extends AbstractCompactionStrategy> compactionStrategyClass, Map<String, String> options) {
        logger.info("Switching local compaction strategy from {} to {} with options={}", new Object[]{this.repaired == null ? "null" : this.repaired.getClass(), compactionStrategyClass, options});
        this.setStrategy(compactionStrategyClass, options);
        if (this.shouldBeEnabled()) {
            this.enable();
        } else {
            this.disable();
        }
        this.startup();
    }

    private void setStrategy(Class<? extends AbstractCompactionStrategy> compactionStrategyClass, Map<String, String> options) {
        if (this.repaired != null) {
            this.repaired.shutdown();
        }
        if (this.unrepaired != null) {
            this.unrepaired.shutdown();
        }
        this.repaired = CFMetaData.createCompactionStrategyInstance(compactionStrategyClass, this.cfs, options);
        this.unrepaired = CFMetaData.createCompactionStrategyInstance(compactionStrategyClass, this.cfs, options);
        this.options = ImmutableMap.copyOf(options);
    }
}

