/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.cassandra.$internal.com.google.common.base.Objects;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.LegacyMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.utils.Pair;

public class Descriptor {
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final Type type;
    private final int hashCode;

    public Descriptor(File directory, String ksname, String cfname, int generation, Type temp) {
        this(Version.CURRENT, directory, ksname, cfname, generation, temp);
    }

    public Descriptor(String version, File directory, String ksname, String cfname, int generation, Type temp) {
        this(new Version(version), directory, ksname, cfname, generation, temp);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, Type temp) {
        assert (version != null && directory != null && ksname != null && cfname != null);
        this.version = version;
        this.directory = directory;
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.type = temp;
        this.hashCode = Objects.hashCode(new Object[]{directory, generation, ksname, cfname, temp});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.type);
    }

    public String filenameFor(Component component) {
        return this.filenameFor(component.name());
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        this.appendFileName(buff);
        return buff.toString();
    }

    private void appendFileName(StringBuilder buff) {
        buff.append(this.ksname).append('-');
        buff.append(this.cfname).append('-');
        if (this.type.isTemporary) {
            buff.append(this.type.marker).append('-');
        }
        buff.append(this.version).append('-');
        buff.append(this.generation);
    }

    public String relativeFilenameFor(Component component) {
        StringBuilder buff = new StringBuilder();
        this.appendFileName(buff);
        buff.append('-').append(component.name());
        return buff.toString();
    }

    public String filenameFor(String suffix) {
        return this.baseFilename() + '-' + suffix;
    }

    public static Descriptor fromFilename(String filename) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)false).left;
    }

    public static Descriptor fromFilename(String filename, boolean skipComponent) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName(), (boolean)skipComponent).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        return Descriptor.fromFilename(directory, name, false);
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name, boolean skipComponent) {
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        String ksname = st.nextToken();
        String cfname = st.nextToken();
        String nexttok = st.nextToken();
        Type type = Type.FINAL;
        if (nexttok.equals(Type.TEMP.marker)) {
            type = Type.TEMP;
            nexttok = st.nextToken();
        } else if (nexttok.equals(Type.TEMPLINK.marker)) {
            type = Type.TEMPLINK;
            nexttok = st.nextToken();
        }
        if (!Version.validate(nexttok)) {
            throw new UnsupportedOperationException("SSTable " + name + " is too old to open.  Upgrade to 2.0 first, and run upgradesstables");
        }
        Version version = new Version(nexttok);
        nexttok = st.nextToken();
        int generation = Integer.parseInt(nexttok);
        String component = null;
        if (!skipComponent) {
            component = st.nextToken();
        }
        directory = directory != null ? directory : new File(".");
        return Pair.create(new Descriptor(version, directory, ksname, cfname, generation, type), component);
    }

    public Descriptor asType(Type type) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, type);
    }

    public IMetadataSerializer getMetadataSerializer() {
        if (this.version.newStatsFile) {
            return new MetadataSerializer();
        }
        return new LegacyMetadataSerializer();
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.type == this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        TEMP("tmp", true),
        TEMPLINK("tmplink", true),
        FINAL(null, false);

        public final boolean isTemporary;
        public final String marker;

        private Type(String marker, boolean isTemporary) {
            this.isTemporary = isTemporary;
            this.marker = marker;
        }
    }

    public static class Version {
        public static final String current_version = "ka";
        public static final Version CURRENT = new Version("ka");
        private final String version;
        public final boolean isLatestVersion;
        public final boolean hasPostCompressionAdlerChecksums;
        public final boolean hasSamplingLevel;
        public final boolean newStatsFile;
        public final boolean hasAllAdlerChecksums;
        public final boolean hasRepairedAt;
        public final boolean tracksLegacyCounterShards;

        public Version(String version) {
            this.version = version;
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.hasPostCompressionAdlerChecksums = version.compareTo("jb") >= 0;
            this.hasSamplingLevel = version.compareTo(current_version) >= 0;
            this.newStatsFile = version.compareTo(current_version) >= 0;
            this.hasAllAdlerChecksums = version.compareTo(current_version) >= 0;
            this.hasRepairedAt = version.compareTo(current_version) >= 0;
            this.tracksLegacyCounterShards = version.compareTo(current_version) >= 0;
        }

        static boolean validate(String ver) {
            return ver != null && ver.matches("[a-z]+");
        }

        public boolean isCompatible() {
            return this.version.compareTo("ja") >= 0 && this.version.charAt(0) <= Version.CURRENT.version.charAt(0);
        }

        public String toString() {
            return this.version;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Version && this.version.equals(((Version)o).version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

