/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.IOException;
import org.apache.cassandra.$internal.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final RandomAccessReader in;

    public KeyIterator(Descriptor desc) {
        File path = new File(desc.filenameFor(Component.PRIMARY_INDEX));
        this.in = RandomAccessReader.open(path);
    }

    @Override
    protected DecoratedKey computeNext() {
        try {
            if (this.in.isEOF()) {
                return (DecoratedKey)this.endOfData();
            }
            DecoratedKey key = StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(this.in));
            RowIndexEntry.Serializer.skip(this.in);
            return key;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.in.close();
    }

    public long getBytesRead() {
        return this.in.getFilePointer();
    }

    public long getTotalBytes() {
        return this.in.length();
    }
}

