/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.$internal.com.google.common.collect.Iterables;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.utils.concurrent.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IAsyncCallback {
    private final SimpleCondition condition = new SimpleCondition();
    protected final Keyspace keyspace;
    protected final long start;
    protected final Collection<InetAddress> naturalEndpoints;
    public final ConsistencyLevel consistencyLevel;
    protected final Runnable callback;
    protected final Collection<InetAddress> pendingEndpoints;
    private final WriteType writeType;

    protected AbstractWriteResponseHandler(Keyspace keyspace, Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Runnable callback, WriteType writeType) {
        this.keyspace = keyspace;
        this.pendingEndpoints = pendingEndpoints;
        this.start = System.nanoTime();
        this.consistencyLevel = consistencyLevel;
        this.naturalEndpoints = naturalEndpoints;
        this.callback = callback;
        this.writeType = writeType;
    }

    public void get() throws WriteTimeoutException {
        boolean success;
        long requestTimeout = this.writeType == WriteType.COUNTER ? DatabaseDescriptor.getCounterWriteRpcTimeout() : DatabaseDescriptor.getWriteRpcTimeout();
        long timeout = TimeUnit.MILLISECONDS.toNanos(requestTimeout) - (System.nanoTime() - this.start);
        try {
            success = this.condition.await(timeout, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            int blockedFor;
            int acks = this.ackCount();
            if (acks >= (blockedFor = this.totalBlockFor())) {
                acks = blockedFor - 1;
            }
            throw new WriteTimeoutException(this.writeType, this.consistencyLevel, acks, blockedFor);
        }
    }

    protected int totalBlockFor() {
        return this.consistencyLevel.blockFor(this.keyspace) + this.pendingEndpoints.size();
    }

    protected abstract int ackCount();

    public abstract void response(MessageIn var1);

    public void assureSufficientLiveNodes() throws UnavailableException {
        this.consistencyLevel.assureSufficientLiveNodes(this.keyspace, Iterables.filter(Iterables.concat(this.naturalEndpoints, this.pendingEndpoints), isAlive));
    }

    protected void signal() {
        this.condition.signalAll();
        if (this.callback != null) {
            this.callback.run();
        }
    }
}

