/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.$internal.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowDataResolver;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.Pair;

public class RangeSliceResponseResolver
implements IResponseResolver<RangeSliceReply, Iterable<Row>> {
    private static final Comparator<Pair<Row, InetAddress>> pairComparator = new Comparator<Pair<Row, InetAddress>>(){

        @Override
        public int compare(Pair<Row, InetAddress> o1, Pair<Row, InetAddress> o2) {
            return ((Row)o1.left).key.compareTo(((Row)o2.left).key);
        }
    };
    private final String keyspaceName;
    private final long timestamp;
    private List<InetAddress> sources;
    protected final Queue<MessageIn<RangeSliceReply>> responses = new ConcurrentLinkedQueue<MessageIn<RangeSliceReply>>();
    public final List<AsyncOneResponse> repairResults = new ArrayList<AsyncOneResponse>();

    public RangeSliceResponseResolver(String keyspaceName, long timestamp) {
        this.keyspaceName = keyspaceName;
        this.timestamp = timestamp;
    }

    public void setSources(List<InetAddress> endpoints) {
        this.sources = endpoints;
    }

    @Override
    public List<Row> getData() {
        assert (!this.responses.isEmpty());
        return ((RangeSliceReply)this.responses.peek().payload).rows;
    }

    @Override
    public Iterable<Row> resolve() {
        ArrayList<RowIterator> iters = new ArrayList<RowIterator>(this.responses.size());
        int n = 0;
        for (MessageIn messageIn : this.responses) {
            RangeSliceReply reply = (RangeSliceReply)messageIn.payload;
            n = Math.max(n, reply.rows.size());
            iters.add(new RowIterator(reply.rows.iterator(), messageIn.from));
        }
        IMergeIterator<Pair<Row, InetAddress>, Row> iter = MergeIterator.get(iters, pairComparator, new Reducer());
        ArrayList<Row> arrayList = new ArrayList<Row>(n);
        while (iter.hasNext()) {
            arrayList.add((Row)iter.next());
        }
        return arrayList;
    }

    @Override
    public void preprocess(MessageIn message) {
        this.responses.add(message);
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    @Override
    public Iterable<MessageIn<RangeSliceReply>> getMessages() {
        return this.responses;
    }

    private class Reducer
    extends MergeIterator.Reducer<Pair<Row, InetAddress>, Row> {
        List<ColumnFamily> versions;
        List<InetAddress> versionSources;
        DecoratedKey key;

        private Reducer() {
            this.versions = new ArrayList<ColumnFamily>(RangeSliceResponseResolver.this.sources.size());
            this.versionSources = new ArrayList<InetAddress>(RangeSliceResponseResolver.this.sources.size());
        }

        @Override
        public void reduce(Pair<Row, InetAddress> current) {
            this.key = ((Row)current.left).key;
            this.versions.add(((Row)current.left).cf);
            this.versionSources.add((InetAddress)current.right);
        }

        @Override
        protected Row getReduced() {
            ColumnFamily resolved;
            ColumnFamily columnFamily = resolved = this.versions.size() > 1 ? RowDataResolver.resolveSuperset(this.versions, RangeSliceResponseResolver.this.timestamp) : this.versions.get(0);
            if (this.versions.size() < RangeSliceResponseResolver.this.sources.size()) {
                for (InetAddress source : RangeSliceResponseResolver.this.sources) {
                    if (this.versionSources.contains(source)) continue;
                    this.versions.add(null);
                    this.versionSources.add(source);
                }
            }
            if (resolved != null) {
                RangeSliceResponseResolver.this.repairResults.addAll(RowDataResolver.scheduleRepairs(resolved, RangeSliceResponseResolver.this.keyspaceName, this.key, this.versions, this.versionSources));
            }
            this.versions.clear();
            this.versionSources.clear();
            return new Row(this.key, resolved);
        }
    }

    private static class RowIterator
    extends AbstractIterator<Pair<Row, InetAddress>>
    implements CloseableIterator<Pair<Row, InetAddress>> {
        private final Iterator<Row> iter;
        private final InetAddress source;

        private RowIterator(Iterator<Row> iter, InetAddress source) {
            this.iter = iter;
            this.source = source;
        }

        @Override
        protected Pair<Row, InetAddress> computeNext() {
            return this.iter.hasNext() ? Pair.create(this.iter.next(), this.source) : (Pair<Row, InetAddress>)this.endOfData();
        }

        @Override
        public void close() {
        }
    }
}

