/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.$internal.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;

public class BatchMessage
extends Message.Request {
    public static final Message.Codec<BatchMessage> codec = new Message.Codec<BatchMessage>(){

        @Override
        public BatchMessage decode(ByteBuf body, int version) {
            if (version == 1) {
                throw new ProtocolException("BATCH messages are not support in version 1 of the protocol");
            }
            byte type = body.readByte();
            int n = body.readUnsignedShort();
            ArrayList<Object> queryOrIds = new ArrayList<Object>(n);
            ArrayList<List<ByteBuffer>> variables = new ArrayList<List<ByteBuffer>>(n);
            for (int i = 0; i < n; ++i) {
                byte kind = body.readByte();
                if (kind == 0) {
                    queryOrIds.add(CBUtil.readLongString(body));
                } else if (kind == 1) {
                    queryOrIds.add(MD5Digest.wrap(CBUtil.readBytes(body)));
                } else {
                    throw new ProtocolException("Invalid query kind in BATCH messages. Must be 0 or 1 but got " + kind);
                }
                variables.add(CBUtil.readValueList(body));
            }
            QueryOptions options = version < 3 ? QueryOptions.fromPreV3Batch(CBUtil.readConsistencyLevel(body)) : QueryOptions.codec.decode(body, version);
            return new BatchMessage(this.toType(type), queryOrIds, variables, options);
        }

        @Override
        public void encode(BatchMessage msg, ByteBuf dest, int version) {
            int queries = msg.queryOrIdList.size();
            dest.writeByte((int)this.fromType(msg.type));
            dest.writeShort(queries);
            for (int i = 0; i < queries; ++i) {
                Object q = msg.queryOrIdList.get(i);
                dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                if (q instanceof String) {
                    CBUtil.writeLongString((String)q, dest);
                } else {
                    CBUtil.writeBytes(((MD5Digest)q).bytes, dest);
                }
                CBUtil.writeValueList(msg.values.get(i), dest);
            }
            if (version < 3) {
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(BatchMessage msg, int version) {
            int size = 3;
            for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                Object q = msg.queryOrIdList.get(i);
                size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfBytes(((MD5Digest)q).bytes));
                size += CBUtil.sizeOfValueList(msg.values.get(i));
            }
            return size += version < 3 ? CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency()) : QueryOptions.codec.encodedSize(msg.options, version);
        }

        private BatchStatement.Type toType(byte b) {
            if (b == 0) {
                return BatchStatement.Type.LOGGED;
            }
            if (b == 1) {
                return BatchStatement.Type.UNLOGGED;
            }
            if (b == 2) {
                return BatchStatement.Type.COUNTER;
            }
            throw new ProtocolException("Invalid BATCH message type " + b);
        }

        private byte fromType(BatchStatement.Type type) {
            switch (type) {
                case LOGGED: {
                    return 0;
                }
                case UNLOGGED: {
                    return 1;
                }
                case COUNTER: {
                    return 2;
                }
            }
            throw new AssertionError();
        }
    };
    public final BatchStatement.Type type;
    public final List<Object> queryOrIdList;
    public final List<List<ByteBuffer>> values;
    public final QueryOptions options;

    public BatchMessage(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, QueryOptions options) {
        super(Message.Type.BATCH);
        this.type = type;
        this.queryOrIdList = queryOrIdList;
        this.values = values;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
                if (this.options.getConsistency() != null) {
                    builder.put("consistency_level", this.options.getConsistency().name());
                }
                if (this.options.getSerialConsistency() != null) {
                    builder.put("serial_consistency_level", this.options.getSerialConsistency().name());
                }
                Tracing.instance.begin("Execute batch of CQL3 queries", builder.build());
            }
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ArrayList<ParsedStatement.Prepared> prepared = new ArrayList<ParsedStatement.Prepared>(this.queryOrIdList.size());
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                ParsedStatement.Prepared p;
                Object query = this.queryOrIdList.get(i);
                if (query instanceof String) {
                    p = QueryProcessor.parseStatement((String)query, state);
                } else {
                    p = handler.getPrepared((MD5Digest)query);
                    if (p == null) {
                        throw new PreparedQueryNotFoundException((MD5Digest)query);
                    }
                }
                List<ByteBuffer> queryValues = this.values.get(i);
                if (queryValues.size() != p.statement.getBoundTerms()) {
                    throw new InvalidRequestException(String.format("There were %d markers(?) in CQL but %d bound variables", p.statement.getBoundTerms(), queryValues.size()));
                }
                prepared.add(p);
            }
            BatchQueryOptions batchOptions = BatchQueryOptions.withPerStatementVariables(this.options, this.values, this.queryOrIdList);
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(prepared.size());
            for (int i = 0; i < prepared.size(); ++i) {
                ParsedStatement.Prepared p = (ParsedStatement.Prepared)prepared.get(i);
                batchOptions.forStatement(i).prepare(p.boundNames);
                if (!(p.statement instanceof ModificationStatement)) {
                    throw new InvalidRequestException("Invalid statement in batch: only UPDATE, INSERT and DELETE statements are allowed.");
                }
                statements.add((ModificationStatement)p.statement);
            }
            BatchStatement batch = new BatchStatement(-1, this.type, statements, Attributes.none());
            ResultMessage response = handler.processBatch(batch, state, batchOptions);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BATCH of [");
        for (int i = 0; i < this.queryOrIdList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
        }
        sb.append("] at consistency ").append((Object)this.options.getConsistency());
        return sb.toString();
    }
}

