/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.$internal.com.google.common.base.Objects;

public class Interval<C, D> {
    public final C min;
    public final C max;
    public final D data;

    public Interval(C min, C max, D data) {
        this.min = min;
        this.max = max;
        this.data = data;
    }

    public static <C, D> Interval<C, D> create(C min, C max) {
        return Interval.create(min, max, null);
    }

    public static <C, D> Interval<C, D> create(C min, C max, D data) {
        return new Interval<C, D>(min, max, data);
    }

    public String toString() {
        return String.format("[%s, %s]%s", this.min, this.max, this.data == null ? "" : String.format("(%s)", this.data));
    }

    public final int hashCode() {
        return Objects.hashCode(this.min, this.max, this.data);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval that = (Interval)o;
        return Objects.equal(this.min, that.min) && Objects.equal(this.max, that.max) && Objects.equal(this.data, that.data);
    }
}

