/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.facebook.presto.hadoop.\$internal.org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import com.facebook.presto.hadoop.\$internal.org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import com.facebook.presto.hadoop.\$internal.org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;

/**
 * This class implements the byte code form for those bytecodes which have regular method references (and only regular method references). These are:
 * invokevirtual invokespecial invokestatic Class-specific references to methods are subclasses of ClassSpecificReferenceForm instead.
 */
public class MethodRefForm extends ReferenceForm {

    public MethodRefForm(final int opcode, final String name, final int[] rewrite) {
        super(opcode, name, rewrite);
    }

    @Override
    protected int getOffset(final OperandManager operandManager) {
        return operandManager.nextMethodRef();
    }

    @Override
    protected int getPoolID() {
        return SegmentConstantPool.CP_METHOD;
    }
}
