/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package com.facebook.presto.hadoop.\$internal.org.apache.http.impl.cookie;

import java.util.Collection;

import com.facebook.presto.hadoop.\$internal.org.apache.http.annotation.Contract;
import com.facebook.presto.hadoop.\$internal.org.apache.http.annotation.ThreadingBehavior;
import com.facebook.presto.hadoop.\$internal.org.apache.http.cookie.CookieSpec;
import com.facebook.presto.hadoop.\$internal.org.apache.http.cookie.CookieSpecFactory;
import com.facebook.presto.hadoop.\$internal.org.apache.http.cookie.CookieSpecProvider;
import com.facebook.presto.hadoop.\$internal.org.apache.http.cookie.params.CookieSpecPNames;
import com.facebook.presto.hadoop.\$internal.org.apache.http.params.HttpParams;
import com.facebook.presto.hadoop.\$internal.org.apache.http.protocol.HttpContext;

/**
 * {@link com.facebook.presto.hadoop.\$internal.org.apache.http.cookie.CookieSpecProvider} implementation that provides an instance of
 * {@link com.facebook.presto.hadoop.\$internal.org.apache.http.impl.cookie.BrowserCompatSpec}. The instance returned by this factory
 * can be shared by multiple threads.
 *
 * @deprecated (4.4) use {@link com.facebook.presto.hadoop.\$internal.org.apache.http.impl.cookie.DefaultCookieSpecProvider}.
 *
 * @since 4.0
 */
@Contract(threading = ThreadingBehavior.IMMUTABLE)
@Deprecated
public class BrowserCompatSpecFactory implements CookieSpecFactory, CookieSpecProvider {

    public enum SecurityLevel {
        SECURITYLEVEL_DEFAULT,
        SECURITYLEVEL_IE_MEDIUM
    }

    private final SecurityLevel securityLevel;
    private final CookieSpec cookieSpec;

    public BrowserCompatSpecFactory(final String[] datepatterns, final SecurityLevel securityLevel) {
        super();
        this.securityLevel = securityLevel;
        this.cookieSpec = new BrowserCompatSpec(datepatterns, securityLevel);
    }

    public BrowserCompatSpecFactory(final String[] datepatterns) {
        this(null, SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    public BrowserCompatSpecFactory() {
        this(null, SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    @Override
    public CookieSpec newInstance(final HttpParams params) {
        if (params != null) {

            String[] patterns = null;
            final Collection<?> param = (Collection<?>) params.getParameter(
                    CookieSpecPNames.DATE_PATTERNS);
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            return new BrowserCompatSpec(patterns, securityLevel);
        } else {
            return new BrowserCompatSpec(null, securityLevel);
        }
    }

    @Override
    public CookieSpec create(final HttpContext context) {
        return this.cookieSpec;
    }

}
