/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package com.facebook.presto.hadoop.\$internal.org.apache.kerby.cms.type;

import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.EnumType;
import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.type.Asn1Any;
import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.type.Asn1ObjectIdentifier;
import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.type.Asn1SequenceType;
import com.facebook.presto.hadoop.\$internal.org.apache.kerby.asn1.type.Asn1Type;

/**
 * OtherCertificateFormat ::= SEQUENCE {
 *   otherCertFormat OBJECT IDENTIFIER,
 *   otherCert ANY DEFINED BY otherCertFormat
 * }
 */
public class OtherCertificateFormat extends Asn1SequenceType {
    protected enum OtherCertificateFormatField implements EnumType {
        OTHER_CERT_FORMAT,
        OTHER_CERT;

        @Override
        public int getValue() {
            return ordinal();
        }

        @Override
        public String getName() {
            return name();
        }
    }

    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[] {
            new Asn1FieldInfo(OtherCertificateFormatField.OTHER_CERT_FORMAT, Asn1ObjectIdentifier.class),
            new Asn1FieldInfo(OtherCertificateFormatField.OTHER_CERT, Asn1Any.class),
    };

    public OtherCertificateFormat() {
        super(fieldInfos);
    }

    public Asn1ObjectIdentifier getOtherCertFormat() {
        return getFieldAs(OtherCertificateFormatField.OTHER_CERT_FORMAT, Asn1ObjectIdentifier.class);
    }

    public void setOtherCertFormat(Asn1ObjectIdentifier otherCertFormat) {
        setFieldAs(OtherCertificateFormatField.OTHER_CERT_FORMAT, otherCertFormat);
    }

    public <T extends Asn1Type> T getOtherCertAs(Class<T> t) {
        return getFieldAsAny(OtherCertificateFormatField.OTHER_CERT, t);
    }

    public void setOtherCert(Asn1Type otherCert) {
        setFieldAsAny(OtherCertificateFormatField.OTHER_CERT, otherCert);
    }
}
