/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.hadoop.\$internal.org.apache.kerby.kerberos.kerb;

import com.facebook.presto.hadoop.\$internal.org.apache.kerby.kerberos.kerb.provider.TokenProvider;
import com.facebook.presto.hadoop.\$internal.org.slf4j.Logger;
import com.facebook.presto.hadoop.\$internal.org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TokenProviderRegistry {
    static final Logger LOG = LoggerFactory.getLogger(TokenProviderRegistry.class);

    private static Map<String, Class> allProvider = new ConcurrentHashMap<>();

    static {
        ServiceLoader<TokenProvider> providers = ServiceLoader.load(TokenProvider.class);

        for (TokenProvider provider : providers) {
            allProvider.put(provider.getTokenType(), provider.getClass());
        }
    }

    public static Set<String> registeredProviders() {
        return Collections.unmodifiableSet(allProvider.keySet());
    }

    public static boolean registeredProvider(String name) {
        return allProvider.containsKey(name);
    }

    public static TokenProvider createProvider(String name) {
        if (!registeredProvider(name)) {
            LOG.error("Unregistered token provider " + name);
            throw new RuntimeException("Unregistered token provider " + name);
        }
        try {
            return (TokenProvider) allProvider.get(name).newInstance();
        } catch (Exception e) {
            LOG.error("Create {} token provider failed", name, e);
            throw new RuntimeException("Create " + name + "token provider failed" + e);
        }
    }
}
