package com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.jcajce.provider.saber;

import com.facebook.presto.hadoop.\$internal.org.bouncycastle.asn1.ASN1Set;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.jcajce.interfaces.SABERKey;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import com.facebook.presto.hadoop.\$internal.org.bouncycastle.util.Arrays;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSABERPrivateKey
        implements PrivateKey, SABERKey
{
    private static final long serialVersionUID = 1L;

    private transient SABERPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSABERPrivateKey(
            SABERPrivateKeyParameters params)
    {
        this.params = params;
    }

    public BCSABERPrivateKey(PrivateKeyInfo keyInfo)
            throws IOException
    {
        init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo)
            throws IOException
    {
        this.attributes = keyInfo.getAttributes();
        this.params = (SABERPrivateKeyParameters) PrivateKeyFactory.createKey(keyInfo);
    }

    /**
     * Compare this SPHINCS-256 private key with another object.
     *
     * @param o the other object
     * @return the result of the comparison
     */
    public boolean equals(Object o)
    {
        if (o == this)
        {
            return true;
        }

        if (o instanceof BCSABERPrivateKey)
        {
            BCSABERPrivateKey otherKey = (BCSABERPrivateKey)o;

            return Arrays.areEqual(params.getEncoded(), otherKey.params.getEncoded());
        }

        return false;
    }

    public int hashCode()
    {
        return Arrays.hashCode(params.getEncoded());
    }

    /**
     * @return name of the algorithm - "SABER"
     */
    public final String getAlgorithm()
    {
        return "SABER";
    }

    public byte[] getEncoded()
    {

        try
        {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(params, attributes);

            return pki.getEncoded();
        }
        catch (IOException e)
        {
            return null;
        }
    }

    public SABERParameterSpec getParameterSpec()
    {
        return SABERParameterSpec.fromName(params.getParameters().getName());
    }

    public String getFormat()
    {
        return "PKCS#8";
    }

    SABERPrivateKeyParameters getKeyParams()
    {
        return params;
    }

    private void readObject(
            ObjectInputStream in)
            throws IOException, ClassNotFoundException
    {
        in.defaultReadObject();

        byte[] enc = (byte[])in.readObject();

        init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(
            ObjectOutputStream out)
            throws IOException
    {
        out.defaultWriteObject();

        out.writeObject(this.getEncoded());
    }
}
