package com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.ser.std;

import java.lang.reflect.Type;
import java.io.IOException;

import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.*;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.*;
import com.facebook.presto.hadoop.$internal.org.codehaus.jackson.map.annotate.JacksonStdImpl;

/**
 * This is a simple dummy serializer that will just output raw values by calling toString()
 * on value to serialize.
 * 
 * @since 1.7
 */
@JacksonStdImpl
public class RawSerializer<T>
    extends SerializerBase<T>
{
    /**
     * Constructor takes in expected type of values; but since caller
     * typically can not really provide actual type parameter, we will
     * just take wild card and coerce type.
     */
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonGenerationException
    {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider,
            TypeSerializer typeSer)
        throws IOException, JsonProcessingException
    {
        typeSer.writeTypePrefixForScalar(value, jgen);
        serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }
    
    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint)
    {
        // type not really known, but since it is a JSON string:
        return createSchemaNode("string", true);
    }
}
