/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.DataOutput;
import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRowDynBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public class VectorAppMasterEventOperator
extends AppMasterEventOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private transient boolean firstBatch;
    private transient VectorExtractRowDynBatch vectorExtractRowDynBatch;
    protected transient Object[] singleRow;

    public VectorAppMasterEventOperator(VectorizationContext vContext, OperatorDesc conf) {
        this.conf = (AppMasterEventDesc)conf;
        this.vContext = vContext;
    }

    public VectorAppMasterEventOperator() {
    }

    @Override
    public Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        Collection<Future<?>> result = super.initializeOp(hconf);
        assert (result.isEmpty());
        this.firstBatch = true;
        return result;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        ObjectInspector rowInspector;
        block7: {
            if (this.hasReachedMaxSize) {
                return;
            }
            VectorizedRowBatch batch = (VectorizedRowBatch)data;
            if (this.firstBatch) {
                this.vectorExtractRowDynBatch = new VectorExtractRowDynBatch();
                this.vectorExtractRowDynBatch.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
                this.singleRow = new Object[this.vectorExtractRowDynBatch.getCount()];
                this.firstBatch = false;
            }
            this.vectorExtractRowDynBatch.setBatchOnEntry(batch);
            rowInspector = this.inputObjInspectors[0];
            try {
                if (batch.selectedInUse) {
                    int[] selected = batch.selected;
                    for (int logical = 0; logical < batch.size; ++logical) {
                        int batchIndex = selected[logical];
                        this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                        Writable writableRow = this.serializer.serialize(this.singleRow, rowInspector);
                        writableRow.write((DataOutput)this.buffer);
                        if ((long)this.buffer.getLength() <= this.MAX_SIZE) continue;
                        this.LOG.info("Disabling AM events. Buffer size too large: " + this.buffer.getLength());
                        this.hasReachedMaxSize = true;
                        this.buffer = null;
                        break block7;
                    }
                    break block7;
                }
                for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                    this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                    Writable writableRow = this.serializer.serialize(this.singleRow, rowInspector);
                    writableRow.write((DataOutput)this.buffer);
                    if ((long)this.buffer.getLength() <= this.MAX_SIZE) continue;
                    this.LOG.info("Disabling AM events. Buffer size too large: " + this.buffer.getLength());
                    this.hasReachedMaxSize = true;
                    this.buffer = null;
                    break;
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        this.forward(data, rowInspector);
        this.vectorExtractRowDynBatch.forgetBatchOnExit();
    }
}

