/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetBytes;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringColumnInList
extends VectorExpression
implements IStringInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private int outputColumn;
    private byte[][] inListValues;
    private transient CuckooSetBytes inSet;

    public StringColumnInList() {
        this.inSet = null;
    }

    public StringColumnInList(int colNum, int outputColumn) {
        this.inputCol = colNum;
        this.outputColumn = outputColumn;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetBytes(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputCol];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] len = inputColVector.length;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = inputColVector.isRepeating;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.inSet.lookup(vector[0], start[0], len[0]) ? 1L : 0L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.inSet.lookup(vector[0], start[0], len[0]) ? 1L : 0L;
            }
            outputColVector.isNull[0] = nullPos[0];
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!nullPos[i]) {
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
                outputColVector.isNull[i] = nullPos[i];
            }
        } else {
            System.arraycopy(nullPos, 0, outputColVector.isNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int value) {
        this.outputColumn = value;
    }

    public int getInputCol() {
        return this.inputCol;
    }

    public void setInputCol(int colNum) {
        this.inputCol = colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    public byte[][] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(byte[][] a) {
        this.inListValues = a;
    }
}

