/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SparkClientUtilities {
    protected static final transient Log LOG = LogFactory.getLog(SparkClientUtilities.class);

    public static void addToClassPath(String[] newPaths, Configuration conf, File localTmpDir) throws Exception {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = (URLClassLoader)cloader;
        ArrayList<URL> curPath = Lists.newArrayList(loader.getURLs());
        for (String newPath : newPaths) {
            URL newUrl = SparkClientUtilities.urlFromPathString(newPath, conf, localTmpDir);
            if (newUrl == null || curPath.contains(newUrl)) continue;
            curPath.add(newUrl);
            LOG.info("Added jar[" + newUrl + "] to classpath.");
        }
        URLClassLoader newLoader = new URLClassLoader(curPath.toArray(new URL[curPath.size()]), (ClassLoader)loader);
        Thread.currentThread().setContextClassLoader(newLoader);
    }

    private static URL urlFromPathString(String path, Configuration conf, File localTmpDir) {
        URL url = null;
        try {
            if (StringUtils.indexOf(path, "file:/") == 0) {
                url = new URL(path);
            } else {
                if (StringUtils.indexOf(path, "hdfs:/") == 0) {
                    Path remoteFile = new Path(path);
                    Path localFile = new Path(localTmpDir.getAbsolutePath() + File.separator + remoteFile.getName());
                    LOG.info("Copying " + remoteFile + " to " + localFile);
                    FileSystem fs = remoteFile.getFileSystem(conf);
                    fs.copyToLocalFile(remoteFile, localFile);
                    return SparkClientUtilities.urlFromPathString(localFile.toString(), conf, localTmpDir);
                }
                url = new File(path).toURL();
            }
        }
        catch (Exception err) {
            LOG.error("Bad URL " + path + ", ignoring path", err);
        }
        return url;
    }
}

