/*
 * Decompiled with CFR 0.152.
 */
package parquet;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;
import parquet.Log;

public class Version {
    private static final Log LOG = Log.getLog(Version.class);
    public static final String VERSION_NUMBER = Version.readVersionNumber();
    public static final String FULL_VERSION = Version.readFullVersion();

    private static String getJarPath() {
        String path;
        int jarEnd;
        URL versionClassBaseUrl = Version.class.getResource("");
        if (versionClassBaseUrl.getProtocol().equals("jar") && (jarEnd = (path = versionClassBaseUrl.getPath()).indexOf("!")) != -1) {
            String jarPath = path.substring(0, jarEnd);
            return jarPath;
        }
        return null;
    }

    private static URL getResourceFromJar(String jarPath, String path) throws IOException {
        Enumeration<URL> resources = Version.class.getClassLoader().getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("jar") || !url.getPath().startsWith(jarPath)) continue;
            return url;
        }
        return null;
    }

    private static String readVersionNumber() {
        String version = null;
        try {
            URL pomPropertiesUrl;
            String jarPath = Version.getJarPath();
            if (jarPath != null && (pomPropertiesUrl = Version.getResourceFromJar(jarPath, "META-INF/maven/com.twitter/parquet-column/pom.properties")) != null) {
                Properties properties = new Properties();
                properties.load(pomPropertiesUrl.openStream());
                version = properties.getProperty("version");
            }
        }
        catch (Exception e) {
            LOG.warn("can't read from META-INF", e);
        }
        return version;
    }

    private static String readFullVersion() {
        String sha = null;
        try {
            URL manifestUrl;
            String jarPath = Version.getJarPath();
            if (jarPath != null && (manifestUrl = Version.getResourceFromJar(jarPath, "META-INF/MANIFEST.MF")) != null) {
                Manifest manifest = new Manifest(manifestUrl.openStream());
                sha = manifest.getMainAttributes().getValue("git-SHA-1");
            }
        }
        catch (Exception e) {
            LOG.warn("can't read from META-INF", e);
        }
        return "parquet-mr" + (VERSION_NUMBER != null ? " version " + VERSION_NUMBER : "") + (sha != null ? " (build " + sha + ")" : "");
    }

    public static void main(String[] args) {
        System.out.println(FULL_VERSION);
    }
}

