/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.DiskRange;

public class DiskRangeList
extends DiskRange {
    private static final Log LOG = LogFactory.getLog(DiskRangeList.class);
    public DiskRangeList prev;
    public DiskRangeList next;

    public DiskRangeList(long offset, long end) {
        super(offset, end);
    }

    public DiskRangeList replaceSelfWith(DiskRangeList other) {
        other.prev = this.prev;
        other.next = this.next;
        if (this.prev != null) {
            this.prev.next = other;
        }
        if (this.next != null) {
            this.next.prev = other;
        }
        this.prev = null;
        this.next = null;
        return other;
    }

    public DiskRangeList insertPartBefore(DiskRangeList other) {
        assert (other.end >= this.offset);
        this.offset = other.end;
        other.prev = this.prev;
        other.next = this;
        if (this.prev != null) {
            this.prev.next = other;
        }
        this.prev = other;
        return other;
    }

    public DiskRangeList insertAfter(DiskRangeList other) {
        other.next = this.next;
        other.prev = this;
        if (this.next != null) {
            this.next.prev = other;
        }
        this.next = other;
        return other;
    }

    public DiskRangeList insertPartAfter(DiskRangeList other) {
        assert (other.offset <= this.end);
        this.end = other.offset;
        return this.insertAfter(other);
    }

    public void removeAfter() {
        DiskRangeList other = this.next;
        this.next = other.next;
        if (this.next != null) {
            this.next.prev = this;
        }
        other.prev = null;
        other.next = null;
    }

    public void removeSelf() {
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        this.prev = null;
        this.next = null;
    }

    public DiskRangeList split(long cOffset) {
        this.insertAfter((DiskRangeList)this.sliceAndShift(cOffset, this.end, 0L));
        return this.replaceSelfWith((DiskRangeList)this.sliceAndShift(this.offset, cOffset, 0L));
    }

    public boolean hasContiguousNext() {
        return this.next != null && this.end == this.next.offset;
    }

    @.VisibleForTesting
    public int listSize() {
        int result = 1;
        DiskRangeList current = this.next;
        while (current != null) {
            ++result;
            current = current.next;
        }
        return result;
    }

    @.VisibleForTesting
    public DiskRangeList[] listToArray() {
        DiskRangeList[] result = new DiskRangeList[this.listSize()];
        int i = 0;
        DiskRangeList current = this.next;
        while (current != null) {
            result[i] = current;
            ++i;
            current = current.next;
        }
        return result;
    }

    public static class DiskRangeListMutateHelper
    extends DiskRangeList {
        public DiskRangeListMutateHelper(DiskRangeList head) {
            super(-1L, -1L);
            assert (head != null);
            assert (head.prev == null);
            this.next = head;
            head.prev = this;
        }

        public DiskRangeList get() {
            return this.next;
        }

        public DiskRangeList extract() {
            DiskRangeList result = this.next;
            assert (result != null);
            result.prev = null;
            this.next = null;
            return result;
        }
    }

    public static class DiskRangeListCreateHelper {
        private DiskRangeList tail = null;
        private DiskRangeList head;

        public DiskRangeList getTail() {
            return this.tail;
        }

        public void addOrMerge(long offset, long end, boolean doMerge, boolean doLogNew) {
            if (doMerge && this.tail != null && this.tail.merge(offset, end)) {
                return;
            }
            if (doLogNew) {
                LOG.info("Creating new range; last range (which can include some previous adds) was " + this.tail);
            }
            DiskRangeList node = new DiskRangeList(offset, end);
            if (this.tail == null) {
                this.head = this.tail = node;
            } else {
                this.tail = this.tail.insertAfter(node);
            }
        }

        public DiskRangeList get() {
            return this.head;
        }

        public DiskRangeList extract() {
            DiskRangeList result = this.head;
            this.head = null;
            return result;
        }
    }
}

